from calibre.customize import FileTypePlugin

class SplitParagraphsPlugin(FileTypePlugin):
    name = 'Split Paragraphs Plugin'
    description = 'Splits text into paragraphs of 4 lines.'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Your Name'
    version = (1, 0, 0)
    file_types = set(['txt', 'epub'])
    
    def run(self, path_to_ebook):
        from calibre_plugins.split_paragraphs.plugin import split_paragraphs
        split_paragraphs(path_to_ebook)
