#!/bin/sh
Output="Device: $(cat /etc/devicename)\nSerial: $(cat /var/run/serial)\n\ninternal SD:\nCID-internal SD: $(cat /sys/block/mmcblk0/device/serial)\nSize-internal SD: $(cat /sys/block/mmcblk0/size)\n\nexternal SD:\nCID-external SD: $(cat /sys/block/mmcblk1/device/serial)\nSize-external SD: $(cat /sys/block/mmcblk1/size)\n\nVCOM: $(cat /boot/vcom)\n\nMD5 values:\n"
cd /boot
MD5="$(md5sum *.wbf | awk '{print $2" "$1}')"
PRODUCT_NAME="`cat /ebrmain/config/device.cfg | awk -F = '/^usb_product_name=/ {print $2}'`"
fw="`awk -F = '/^ver=/ {print $2}' /ebrmain/.version`"
variant="`awk -F = '/^variant=/ {print $2}' /ebrmain/config/device.cfg`"
echo -e "Device name: $PRODUCT_NAME\nFirmware: $fw\nVariant: $variant\n\n$Output$MD5" > /mnt/ext2/deviceinformation.txt