﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using BBeBLib;

namespace ConvertIMPGUI
{
    public partial class frmConvertIMPTxtToLRF : Form
    {
        private ListView.ListViewItemCollection _list;

        public frmConvertIMPTxtToLRF()
        {
            InitializeComponent();
        }

        public ListView.ListViewItemCollection List
        {
            set { _list = value; }
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            if (LRFFolderDlg.ShowDialog() == DialogResult.OK)
            {
                txtLRFOutput.Text = LRFFolderDlg.SelectedPath;

                if (!txtLRFOutput.Text.EndsWith(@"\"))
                    txtLRFOutput.Text += @"\";

                btnStart.Enabled = true;
            }
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            Cursor = Cursors.WaitCursor;
            Application.DoEvents();

            convertProgress.Minimum = 0;
            convertProgress.Value = 0;
            convertProgress.Maximum = _list.Count;
            lblProgress.Text = convertProgress.Value + " of " + convertProgress.Maximum;
            Application.DoEvents();

            foreach (ListViewItem item in _list)
            {
                CIMPFile impFile = (CIMPFile)item.Tag;
                convertProgress.Value = convertProgress.Value + 1;
                lblProgress.Text = "Book " + convertProgress.Value + " of " + convertProgress.Maximum + " (" + impFile.BookProperties.FirstName + " - " + impFile.BookProperties.Title + ")";
                Application.DoEvents();

                try
                {
                    impFile.ReadIMP(ref lblBook, ref bookProgress);
                    impFile.ReverseResourceFile(ref lblBook, ref bookProgress);

                    string newFileName = impFile.BookProperties.FirstName + " - " + impFile.BookProperties.Title;

                    newFileName = newFileName.Replace("/", " ");
                    newFileName = newFileName.Replace(@"\", " ");
                    newFileName = newFileName.Replace(":", " ");
                    newFileName = newFileName.Replace("?", " ");
                    newFileName = newFileName.Replace("*", " ");
                    newFileName = newFileName.Replace("<", " ");
                    newFileName = newFileName.Replace(">", " ");
                    newFileName = newFileName.Replace("|", " ");

                    string textFile = txtLRFOutput.Text + newFileName + ".txt";
                    StreamWriter sw = new StreamWriter(textFile);
                    sw.Write(impFile.Content);
                    sw.Close();

                    impFile.ReadForDisplay();

                    BindingParams config = new BindingParams();
                    config.MetaData = new BookMetaData();
                    config.MetaData.BookInfo.Author = impFile.BookProperties.FirstName;
                    config.MetaData.BookInfo.BookID = impFile.BookProperties.ID;
                    config.MetaData.BookInfo.Category = impFile.BookProperties.Bookshelf_Category;
                    config.MetaData.DocInfo.CreationDate = DateTime.Now.ToShortDateString();
                    config.MetaData.DocInfo.Language = "en";
                    config.MetaData.DocInfo.Creator = "ConvertIMPGUI";
                    config.MetaData.DocInfo.Producer = "ConvertIMPGUI";

                    LegacyBBeB book = new LegacyBBeB(config.MetaData);
                    book.BeginBook();
                    PseudoHtmlReader reader = new PseudoHtmlReader(book);
                    reader.ReadFile(textFile);
                    book.FinalizeBook(Application.StartupPath + @"\BookThumbnail.gif");
                    book.WriteToFile(txtLRFOutput.Text + newFileName + ".lrf");

                    File.Delete(textFile);
                }
                catch (Exception exc)
                {
                    System.Diagnostics.Debug.WriteLine("BAD ERROR");
                    System.Diagnostics.Debug.WriteLine(exc.ToString());
                }
            }

            Cursor = Cursors.Default;
            Application.DoEvents();
        }
    }
}
