#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Copyright (c) 2019 John Crew

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, for commercial and non-commercial purposes are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor contributors may be used to endorse or promote products derived from this software.

4. The source code, and any derived source code, must be made available to users of this software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""

import re
import tkinter.ttk as tkinter_ttk	#Essential for ttk. commands

def centerWindow(win):
	"""
	This function centres the window that is passed to it as the parameter.
	Always set up the widgets in the window to be centred before calling this function
	Does not take the size of the title bar or any menus into consideration
	"""
	win.update_idletasks()  # Update "requested size" from geometry manager
	xpos = (win.winfo_screenwidth() - win.winfo_reqwidth()) / 2
	ypos = (win.winfo_screenheight() - win.winfo_reqheight()) / 2
	win.geometry("+%d+%d" % (xpos, ypos))
	win.deiconify()