# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST 2024 DJG'
__my_version__ = "2.0.4"  # Miscellany

from calibre.customize import InterfaceActionBase

class ActionBaseLibraryCodes(InterfaceActionBase):

    name                    = 'Library Codes - SRU'
    description           = "Derive Library of Congress Codes, Dewey Decimal Codes, and/or OCLC-OWI plus Other Identifiers for Selected Books Using ISBN or ISSN."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST 2024 additions DJG'
    version                 = (2, 0, 4)
    minimum_calibre_version = (6, 0, 0)

    actual_plugin           = 'calibre_plugins.library_codes.ui:ActionLibraryCodes'

    gui_name = 'Library Codes - SRU'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return True
    #--------------------------------------------------------------------------------------------------------------------------
    def config_widget(self):
        from calibre_plugins.library_codes.config import ConfigWidget
        return ConfigWidget()
    #--------------------------------------------------------------------------------------------------------------------------
    def save_settings(self, ConfigWidget):
        ConfigWidget.save_settings()
        # Apply the changes
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()
    #-------------------------------------------
#END of __init__py
