CREATE TABLE DbVersion(version INTEGER NOT NULL, PRIMARY KEY(version));
CREATE TABLE content(
    ContentID TEXT NOT NULL,
    ContentType TEXT NOT NULL,
    MimeType TEXT NOT NULL,
    BookID TEXT,
    BookTitle TEXT,
    ImageId TEXT,
    Title TEXT COLLATE NOCASE,
    Attribution TEXT COLLATE NOCASE,
    Description TEXT,
    DateCreated TEXT,
    ShortCoverKey TEXT,
    adobe_location TEXT,
    Publisher TEXT,
    IsEncrypted BOOL,
    DateLastRead TEXT,
    FirstTimeReading BOOL,
    ChapterIDBookmarked TEXT,
    ParagraphBookmarked INTEGER,
    BookmarkWordOffset INTEGER,
    NumShortcovers INTEGER,
    VolumeIndex INTEGER,
    ___NumPages INTEGER,
    ReadStatus INTEGER,
    ___SyncTime TEXT,
    ___UserID TEXT NOT NULL,
    PublicationId TEXT,
    ___FileOffset INTEGER,
    ___FileSize INTEGER,
    ___PercentRead INTEGER,
    ___ExpirationStatus INTEGER,
    FavouritesIndex NOT NULL DEFAULT -1,
    Accessibility INTEGER DEFAULT 1,
    ContentURL TEXT,
    Language TEXT,
    BookshelfTags TEXT,
    IsDownloaded BIT NOT NULL DEFAULT 1,
    FeedbackType INTEGER DEFAULT 0,
    AverageRating INTEGER DEFAULT 0,
    Depth INTEGER,
    PageProgressDirection TEXT,
    InWishlist BOOL NOT NULL DEFAULT FALSE,
    ISBN TEXT,
    WishlistedDate TEXT DEFAULT "0000-00-00T00:00:00.000",
    FeedbackTypeSynced INTEGER DEFAULT 0,
    IsSocialEnabled BOOL NOT NULL DEFAULT TRUE,
    EpubType INT NOT NULL DEFAULT -1,
    Monetization INTEGER DEFAULT 2,
    ExternalId TEXT,
    Series TEXT,
    SeriesNumber TEXT,
    Subtitle TEXT,
    WordCount INTEGER DEFAULT -1,
    Fallback TEXT,
    RestOfBookEstimate INTEGER,
    CurrentChapterEstimate INTEGER,
    CurrentChapterProgress FLOAT,
    PocketStatus INTEGER DEFAULT 0,
    UnsyncedPocketChanges TEXT,
    ImageUrl TEXT,
    DateAdded TEXT,
    WorkId TEXT,
    Properties TEXT,
    RenditionSpread TEXT,
    RatingCount INTEGER DEFAULT 0,
    ReviewsSyncDate TEXT,
    MediaOverlay TEXT,
    MediaOverlayType TEXT,
    RedirectPreviewUrl TEXT,
    PreviewFileSize INTEGER,
    EntitlementId TEXT,
    CrossRevisionId TEXT,
    DownloadUrl TEXT,
    ReadStateSynced BIT NOT NULL DEFAULT false,
    TimesStartedReading INTEGER,
    TimeSpentReading INTEGER,
    LastTimeStartedReading TEXT,
    LastTimeFinishedReading TEXT,
    ApplicableSubscriptions TEXT,
    ExternalIds TEXT,
    PurchaseRevisionId TEXT,
    SeriesID TEXT,
    SeriesNumberFloat REAL,
    AdobeLoanExpiration TEXT,
    HideFromHomePage bit,
    IsInternetArchive BOOL NOT NULL DEFAULT FALSE,
    titleKana TEXT,
    subtitleKana TEXT,
    seriesKana TEXT,
    attributionKana TEXT,
    publisherKana TEXT,
    IsPurchaseable BOOL DEFAULT TRUE,
    IsSupported BOOL DEFAULT TRUE,
    AnnotationsSyncToken TEXT,
    DateModified TEXT DEFAULT "0000-00-00T00:00:00.000",
    StorePages INTEGER DEFAULT 0,
    StoreWordCount INTEGER DEFAULT 0,
    StoreTimeToReadLowerEstimate INTEGER DEFAULT 0,
    StoreTimeToReadUpperEstimate INTEGER DEFAULT 0,
    Duration INTEGER DEFAULT 0,
    IsAbridged BOOL DEFAULT NULL,
    SyncConflictType INTEGER DEFAULT 0,
    isLcpEpub BOOL NOT NULL DEFAULT FALSE,
    `familySharing` INTEGER DEFAULT 0,
    `familySharingRelation` TEXT DEFAULT NULL,
    `subscriptionType` INTEGER DEFAULT -1,
    metaDataJson TEXT,
    isAdobeDrm BOOL NOT NULL DEFAULT FALSE,
    PRIMARY KEY (ContentID)
);
CREATE TABLE shortcover_page (
    shortcoverId TEXT not null,
    PageNumber INTEGER,
    FormattedPage TEXT,
    PRIMARY KEY (shortcoverId, PageNumber)
);
CREATE TABLE volume_shortcovers(
    volumeId TEXT NOT NULL,
    shortcoverId TEXT NOT NULL,
    VolumeIndex INTEGER,
    PRIMARY KEY (volumeId, shortcoverId)
);
CREATE TABLE content_keys (
    volumeId TEXT NOT NULL,
    elementId TEXT NOT NULL,
    elementKey TEXT,
    PRIMARY KEY (volumeId, elementId)
);
CREATE TABLE Bookmark (
    BookmarkID TEXT NOT NULL,
    VolumeID TEXT NOT NULL,
    ContentID TEXT NOT NULL,
    StartContainerPath TEXT NOT NULL,
    StartContainerChildIndex INTEGER NOT NULL,
    StartOffset INTEGER NOT NULL,
    EndContainerPath TEXT NOT NULL,
    EndContainerChildIndex INTEGER NOT NULL,
    EndOffset INTEGER NOT NULL,
    Text TEXT,
    Annotation TEXT,
    ExtraAnnotationData BLOB,
    DateCreated TEXT,
    ChapterProgress REAL NOT NULL DEFAULT 0,
    Hidden BOOL NOT NULL DEFAULT 0,
    Version TEXT,
    DateModified TEXT,
    Creator TEXT,
    UUID TEXT,
    UserID TEXT,
    SyncTime TEXT,
    Published BIT default false,
    ContextString TEXT,
    Type TEXT,
    Color INTEGER DEFAULT 0,
    PRIMARY KEY (BookmarkID)
);
CREATE TABLE Event (
    EventType INTEGER NOT NULL,
    FirstOccurrence TEXT,
    LastOccurrence TEXT,
    EventCount INTEGER DEFAULT 0,
    ContentID TEXT,
    ExtraData BLOB,
    Checksum TEXT,
    PRIMARY KEY (EventType, ContentID)
);
CREATE TABLE Achievement(
    Acknowledged BOOL,
    CompleteDescription TEXT,
    DateCreated TEXT,
    Difficulty INTEGER,
    EventLogDescription TEXT,
    Hidden BOOL,
    Id TEXT NOT NULL,
    ImageId TEXT NOT NULL,
    IncompleteDescription TEXT,
    Name TEXT NOT NULL,
    Ordinal INTEGER,
    PercentComplete INTEGER,
    Presented BOOL,
    Synchronized BOOL,
    UserId TEXT,
    Checksum TEXT,
    FacebookImageId TEXT,
    PRIMARY KEY (Id)
);
CREATE TABLE Rules(
    AchievementId TEXT,
    EventProperty TEXT,
    EventType TEXT,
    GoalValue TEXT NOT NULL,
    Id TEXT NOT NULL,
    Operation INT NOT NULL,
    ParentRuleId TEXT,
    ConjunctionType INT,
    IsConjunction BOOL,
    Checksum TEXT,
    PRIMARY KEY(Id)
);
CREATE TABLE volume_tabs (
    volumeId TEXT NOT NULL,
    tabId TEXT NOT NULL DEFAULT 'abcdefff-ffff-ffff-ffff-fffffffffffd',
    PRIMARY KEY (volumeId, tabId)
);
CREATE TABLE ratings (
    ContentID TEXT NOT NULL,
    Rating INTEGER,
    Review TEXT,
    DateModified TEXT NOT NULL,
    PRIMARY KEY(ContentID)
);
CREATE TABLE ShelfContent (
    ShelfName TEXT,
    ContentId TEXT,
    DateModified TEXT,
    _IsDeleted BOOL,
    _IsSynced BOOL,
    PRIMARY KEY(ShelfName, ContentId)
);
CREATE TABLE content_settings (
    ContentID TEXT NOT NULL,
    ContentType INTEGER NOT NULL,
    DateModified TEXT NOT NULL,
    ReadingFontFamily TEXT,
    ReadingFontSize INTEGER,
    ReadingAlignment TEXT,
    ReadingLineHeight REAL,
    ReadingLeftMargin INTEGER,
    ReadingRightMargin INTEGER,
    ReadingPublisherMode INTEGER,
    ActivityFacebookShare BIT default TRUE,
    RecentBookSearches TEXT,
    AuthorNotesShown BIT default false,
    LastAuthorNotesSyncTime TEXT,
    ZoomFactor INTEGER default 1,
    BTBFooterSection TEXT,
    SelectedDictionary TEXT,
    StillReading BIT DEFAULT FALSE,
    SeriesShown BIT DEFAULT FALSE,
    PRIMARY KEY (ContentID, ContentType)
);
CREATE TABLE Shelf (
    CreationDate TEXT,
    Id TEXT,
    InternalName TEXT,
    LastModified TEXT,
    Name TEXT,
    Type TEXT,
    _IsDeleted BOOL,
    _IsVisible BOOL,
    _IsSynced BOOL,
    _SyncTime TEXT,
    LastAccessed TEXT,
    PRIMARY KEY(Id)
);
CREATE TABLE user(
    UserID TEXT NOT NULL,
    UserKey TEXT NOT NULL,
    UserDisplayName TEXT,
    UserEmail TEXT,
    ___DeviceID TEXT,
    FacebookAuthToken TEXT,
    HasMadePurchase BIT DEFAULT FALSE,
    IsOneStoreAccount BIT DEFAULT FALSE,
    IsChildAccount BIT DEFAULT FALSE,
    RefreshToken TEXT,
    AuthToken TEXT,
    AuthType TEXT,
    Loyalty BLOB,
    IsLibraryMigrated BIT NOT NULL DEFAULT true,
    SyncContinuationToken TEXT,
    Subscription INT NOT NULL DEFAULT 0,
    LibrarySyncType TEXT,
    LibrarySyncTime TEXT,
    SyncTokenAppVersion TEXT,
    Storefront TEXT,
    NewUserPromoCurrency TEXT,
    NewUserPromoValue REAL NOT NULL DEFAULT -1.0,
    KoboAccessToken TEXT,
    KoboAccessTokenExpiry TEXT,
    AnnotationsSyncToken TEXT,
    PrivacyPermissions BLOB,
    AnnotationsMigrated BIT NOT NULL DEFAULT false,
    NotebookSyncTime TEXT,
    NotebookSyncToken TEXT,
    PRIMARY KEY (UserID)
);
CREATE TABLE SyncQueue (
    Date TEXT,
    VolumeId TEXT,
    State INT,
    PRIMARY KEY(VolumeId)
);
CREATE TABLE AbTest(
    Id TEXT,
    Expiration TEXT,
    Name TEXT,
    GroupId INT,
    Variables TEXT,
    Status INT,
    Description TEXT,
    Checksum TEXT,
    TestKey TEXT,
    PRIMARY KEY(Id)
);
CREATE TABLE AnalyticsEvents(
    Id TEXT,
    Type TEXT,
    Timestamp TEXT,
    Attributes TEXT,
    Metrics TEXT,
    TestGroups TEXT,
    ClientApplicationVersion TEXT,
    Mandatory BIT DEFAULT FALSE,
    PRIMARY KEY(Id)
);
CREATE TABLE Activity (
    Id TEXT,
    Enabled BIT default TRUE,
    Type TEXT,
    Action INTEGER,
    Date TEXT,
    Data BLOB,
    PRIMARY KEY(Id, Type)
);
CREATE TABLE Authors(
    UserId TEXT,
    Avatar TEXT,
    Name TEXT,
    FacebookId TEXT,
    PRIMARY KEY(UserID)
);
CREATE TABLE BookAuthors(
    AuthorId TEXT,
    BookId TEXT,
    PRIMARY KEY(AuthorId, BookId)
);
CREATE TABLE Reviews (
    Id TEXT NOT NULL,
    Header TEXT,
    Content TEXT,
    CreationDate TEXT,
    VolumeId TEXT NOT NULL,
    AuthorDisplayName TEXT,
    Sentiment TEXT,
    UserId TEXT,
    Likes INTEGER,
    Dislikes INTEGER,
    Rating INTEGER,
    SyncDate TEXT,
    Status TEXT,
    PRIMARY KEY(Id)
);
CREATE TABLE Tab (
    tabId TEXT NOT NULL,
    tabType TEXT,
    browseTabType TEXT,
    displayTitle TEXT,
    parentTabId TEXT,
    isDefault BOOL,
    maxSize INTEGER,
    totalResults INTEGER,
    updateFrequencyMin INTEGER,
    imageID TEXT,
    isLeaf BOOL,
    hasFeaturedLists BOOL,
    etag TEXT,
    language TEXT,
    PRIMARY KEY(tabID)
);
CREATE TABLE OverDriveCards (
    CardId INTEGER NOT NULL,
    LibraryKey TEXT NOT NULL,
    BestLibraryKey TEXT NOT NULL,
    WebsiteId INTEGER NOT NULL,
    Name TEXT,
    LastModified TEXT,
    PRIMARY KEY(CardId)
);
CREATE TABLE OverDriveLibrary (
    Selected BIT NOT NULL DEFAULT false,
    WebsiteId INTEGER NOT NULL,
    LibraryKey TEXT,
    Name TEXT,
    PRIMARY KEY(WebsiteId)
);
CREATE TABLE OverDriveCheckoutBook (
    id TEXT,
    title TEXT,
    libraryKey TEXT,
    cardId TEXT,
    isAvailable TEXT,
    suspensionFlag BIT,
    placedDate TEXT,
    expireDate TEXT,
    estimatedAvailableDate TEXT,
    PRIMARY KEY(id)
);
CREATE TABLE WordList(
    Text TEXT,
    VolumeId TEXT,
    DictSuffix TEXT,
    DateCreated TEXT,
    PRIMARY KEY(Text)
);
CREATE TABLE Wishlist(
    CrossRevisionId TEXT,
    DateModified TEXT NOT NULL,
    IsAdded BOOL,
    IsSynced BOOL,
    PRIMARY KEY(CrossRevisionId)
);
CREATE TABLE SubscriptionProducts (
    CrossRevisionId TEXT NOT NULL,
    Id TEXT NOT NULL,
    Name TEXT,
    IsPreOrder BOOL,
    Tiers TEXT,
    ActivationDate TEXT,
    DeactivationDate TEXT,
    PRIMARY KEY (CrossRevisionId)
);
CREATE TABLE DropboxItem (Id TEXT NOT NULL, Json TEXT, PRIMARY KEY (Id));
CREATE TABLE KoboPlusAssetGroup (
    Id TEXT NOT NULL,
    AssetGroup TEXT,
    Timestamp TEXT,
    Name TEXT,
    Url TEXT,
    Etag TEXT,
    TimestampTo TEXT,
    Shown BOOL DEFAULT FALSE,
    PRIMARY KEY (Id)
);
CREATE TABLE KoboPlusAssets (
    AssetGroupId TEXT NOT NULL,
    Key TEXT NOT NULL,
    Language TEXT NOT NULL,
    Type TEXT,
    Value TEXT,
    FOREIGN KEY (AssetGroupId) REFERENCES KoboPlusAssetGroup(Id),
    PRIMARY KEY (AssetGroupId, Key, Language)
);
CREATE TABLE GDriveItem (
    Id TEXT NOT NULL,
    Json TEXT,
    Path TEXT,
    PRIMARY KEY (Id)
);
CREATE TABLE `tolino_author` (
    `id` INTEGER PRIMARY KEY AUTOINCREMENT,
    `uuid` TEXT NOT NULL,
    `name` TEXT DEFAULT NULL,
    `firstName` TEXT DEFAULT NULL,
    `lastName` TEXT DEFAULT NULL,
    `type` INTEGER DEFAULT 1
);
CREATE TABLE sqlite_sequence(name, seq);
CREATE TABLE `tolino_bookmark` (
    `id` INTEGER PRIMARY KEY AUTOINCREMENT,
    `uuid` TEXT NOT NULL,
    `currentPosition` TEXT DEFAULT NULL,
    `lastPosition` TEXT DEFAULT NULL,
    `modified` INTEGER DEFAULT 0,
    `position` TEXT DEFAULT NULL,
    `progress` FLOAT DEFAULT 0,
    `revision` TEXT DEFAULT NULL,
    `backendId` INTEGER DEFAULT 0,
    `deletedLocally` INTEGER DEFAULT 0,
    `modifiedLocally` INTEGER DEFAULT 0,
    isAudiobook BOOL NOT NULL DEFAULT FALSE
);
CREATE TABLE `tolino_bookshelfRevision` (
    `id` INTEGER PRIMARY KEY AUTOINCREMENT,
    `revision` TEXT DEFAULT NULL
);
CREATE TABLE `tolino_comment` (
    `id` INTEGER PRIMARY KEY AUTOINCREMENT,
    `uuid` TEXT NOT NULL,
    `endPosition` TEXT DEFAULT NULL,
    `modified` INTEGER DEFAULT 0,
    `note` TEXT DEFAULT NULL,
    `revision` TEXT DEFAULT NULL,
    `startPosition` TEXT DEFAULT NULL,
    `text` TEXT DEFAULT NULL,
    `backendId` INTEGER DEFAULT 0,
    `deletedLocally` INTEGER DEFAULT 0,
    `modifiedLocally` INTEGER DEFAULT 0,
    `koboBookmarkId` TEXT DEFAULT NULL,
    `koboContentId` TEXT DEFAULT NULL,
    `color` INTEGER DEFAULT 0
);
CREATE TABLE `tolino_contentItem` (
    `uuid` TEXT PRIMARY KEY,
    `publicationId` TEXT DEFAULT NULL,
    `transactionId` TEXT DEFAULT NULL,
    `title` TEXT DEFAULT NULL,
    `abstract` TEXT DEFAULT NULL,
    `contentFormat` TEXT DEFAULT NULL,
    `contentProtectionType` INTEGER DEFAULT 0,
    `contentSources` INTEGER DEFAULT 0,
    `contentType` INTEGER DEFAULT 0,
    `defaultCover` INTEGER DEFAULT 0,
    `externalDownloadAvailable` INTEGER DEFAULT 0,
    `familySharing` INTEGER DEFAULT 0,
    `frontCoverUrl` TEXT DEFAULT NULL,
    `scaledCoverUrl` TEXT DEFAULT NULL,
    `contentPreviewUrl` TEXT DEFAULT NULL,
    `contentIsPreview` INTEGER DEFAULT NULL,
    `isbnEan` TEXT DEFAULT NULL,
    `issuedDate` INTEGER DEFAULT 0,
    `keywords` TEXT DEFAULT NULL,
    `language` TEXT DEFAULT NULL,
    `publisher` TEXT DEFAULT NULL,
    `purchasedDate` INTEGER DEFAULT 0,
    `resellerId` TEXT DEFAULT NULL,
    `resellerName` TEXT DEFAULT NULL,
    `sequenceNo` INTEGER DEFAULT 0,
    `shelfId` TEXT DEFAULT NULL,
    `subtitle` TEXT DEFAULT NULL,
    `isTextToSpeechEnabled` INTEGER DEFAULT 0,
    `isTranslationEnabled` INTEGER DEFAULT 0,
    `renderingEngine` INTEGER DEFAULT 0,
    `subscriptionId` TEXT DEFAULT NULL,
    `subscriptionType` INTEGER DEFAULT 0,
    `offlineDurationInDays` INTEGER DEFAULT 0,
    `openUntil` TEXT DEFAULT NULL,
    `reasonOpenUntil` TEXT DEFAULT NULL,
    `stableBookId` TEXT DEFAULT NULL
);
CREATE TABLE `tolino_contentItemPendingDeletions` (
    `id` INTEGER PRIMARY KEY AUTOINCREMENT,
    `uuid` TEXT UNIQUE NOT NULL,
    `publicationId` TEXT DEFAULT NULL,
    `transactionId` TEXT DEFAULT NULL,
    `retryCounter` INTEGER DEFAULT 0,
    `lastDeletionAttemptTimeStamp` INTEGER DEFAULT 0
);
CREATE TABLE `tolino_dogear` (
    `id` INTEGER PRIMARY KEY AUTOINCREMENT,
    `uuid` TEXT NOT NULL,
    `modified` INTEGER DEFAULT 0,
    `name` TEXT DEFAULT NULL,
    `position` TEXT DEFAULT NULL,
    `revision` TEXT DEFAULT NULL,
    `backendId` INTEGER DEFAULT 0,
    `deletedLocally` INTEGER DEFAULT 0,
    `modifiedLocally` INTEGER DEFAULT 0
);
CREATE TABLE `tolino_drmKeysKobo` (
    `id` INTEGER PRIMARY KEY AUTOINCREMENT,
    `uuid` TEXT NOT NULL,
    `key` TEXT NOT NULL,
    `value` TEXT NOT NULL
);
CREATE TABLE `tolino_skoobeChapter` (
    `id` INTEGER PRIMARY KEY AUTOINCREMENT,
    `stableBookId` TEXT NOT NULL,
    `chapterNo` INTEGER DEFAULT 0,
    `charLength` INTEGER DEFAULT 0,
    `charPosition` INTEGER DEFAULT 0,
    `wordCount` INTEGER DEFAULT 0
);
CREATE TABLE `tolino_tag` (
    `id` INTEGER PRIMARY KEY AUTOINCREMENT,
    `uuid` TEXT DEFAULT NULL,
    `category` TEXT NOT NULL,
    `modified` INTEGER DEFAULT 0,
    `name` TEXT DEFAULT NULL,
    `revision` TEXT DEFAULT NULL,
    `backendId` INTEGER DEFAULT 0,
    `deletedLocally` INTEGER DEFAULT 0,
    `modifiedLocally` INTEGER DEFAULT 0
);
CREATE TABLE `tolino_resellerHandshake` (
    `resellerId` INTEGER UNIQUE NOT NULL PRIMARY KEY,
    `resellerDisplayName` TEXT DEFAULT NULL,
    `isConnected` INTEGER DEFAULT 0,
    `logoUrl` TEXT DEFAULT NULL
);
CREATE TABLE `tolino_familyMembers` (
    `membershipId` INTEGER UNIQUE NOT NULL PRIMARY KEY,
    `nickname` TEXT DEFAULT NULL,
    `isOwner` INTEGER DEFAULT 0
);
CREATE TABLE `tolino_contentItemExtraData` (
    `uuid` TEXT UNIQUE NOT NULL PRIMARY KEY,
    `localPath` TEXT DEFAULT NULL,
    `familySharingRelation` TEXT DEFAULT NULL,
    `purchaseUrl` TEXT DEFAULT NULL
);
CREATE TABLE `tolino_recommendations` (
    `publicationId` TEXT UNIQUE NOT NULL PRIMARY KEY,
    `author` TEXT DEFAULT NULL,
    `cover_url` TEXT DEFAULT NULL,
    `description` TEXT DEFAULT NULL,
    `publicationType` TEXT DEFAULT NULL,
    `shop_url` TEXT DEFAULT NULL,
    `title` TEXT DEFAULT NULL,
    `context` TEXT DEFAULT NULL,
    `recosJson` TEXT DEFAULT NULL
);
CREATE TABLE `tolino_contentItemAudioInfo` (
    `uuid` TEXT UNIQUE NOT NULL PRIMARY KEY,
    `bitrate` TEXT DEFAULT NULL,
    `fileFormat` TEXT DEFAULT NULL,
    `finished` INTEGER DEFAULT 0,
    `lastUsedDate` INTEGER DEFAULT 0,
    `overallDuration` INTEGER DEFAULT 0,
    `tracksNumber` INTEGER DEFAULT 0
);
CREATE TABLE `tolino_downloadInfo` (
    `uuid` TEXT NOT NULL,
    `contentUrl` TEXT DEFAULT NULL,
    `format` TEXT DEFAULT NULL,
    `fileSize` INTEGER DEFAULT 0,
    `location` TEXT DEFAULT NULL,
    `trackNo` INTEGER DEFAULT 0,
    `trackDuration` INTEGER DEFAULT 0,
    `encryptionType` TEXT DEFAULT NULL,
    `encryptionKey` TEXT DEFAULT NULL,
    `initializationVector` TEXT DEFAULT NULL,
    `algorithm` TEXT DEFAULT NULL,
    PRIMARY KEY (`uuid`, `trackNo`)
);
CREATE TABLE `tolino_skoobeReadingTime` (
    `journalId` INTEGER PRIMARY KEY AUTOINCREMENT,
    `tolinoBookshelfId` INTEGER DEFAULT 0,
    `stableBookId` TEXT NOT NULL,
    `startWord` INTEGER DEFAULT 0,
    `endWord` INTEGER DEFAULT 0,
    `timestamp` INTEGER DEFAULT 0,
    `percentage` REAL DEFAULT 0
);
CREATE TABLE `tolino_languageConfig` (
    `language` TEXT PRIMARY KEY,
    `STRING_ARRAY_ACTIVATION_ADVANTAGES` TEXT NOT NULL,
    `STRING_ARRAY_SUPPORT_CONTACT` TEXT NOT NULL
);
CREATE INDEX content_bookid_index ON content (BookID);
CREATE INDEX volume_shortcovers_shortcoverId ON volume_shortcovers (shortcoverId);
CREATE INDEX volume_tabs_volumeId ON volume_tabs (volumeId);
CREATE INDEX shelfcontent_datemodified_index ON ShelfContent (DateModified);
CREATE INDEX content_settings_index ON content_settings (ContentID, ContentType);
CREATE INDEX shelf_id_index ON shelf (Id);
CREATE INDEX shelf_name_index ON shelf (Name);
CREATE INDEX shelf_creationdate_index ON shelf (CreationDate);
CREATE INDEX analytics_events_timestamp ON AnalyticsEvents (Timestamp);
CREATE INDEX activity_id_index ON Activity (Id);
CREATE INDEX OverDriveCards_LibraryKey_index ON OverDriveCards (LibraryKey);
CREATE INDEX bookmark_content ON bookmark (ContentID);
CREATE INDEX content_keys_volume ON content_keys (volumeid);
CREATE INDEX volume_tabs_tabId ON volume_tabs (tabId);
CREATE INDEX bookmark_volume ON bookmark (VolumeID);
CREATE INDEX kobo_plus_asset_group_index ON KoboPlusAssetGroup(AssetGroup);
CREATE TRIGGER kobo_plus_asset_cleanup BEFORE DELETE ON KoboPlusAssetGroup FOR EACH ROW BEGIN
DELETE FROM KoboPlusAssets
WHERE AssetGroupId = OLD.Id;
END;