#!/usr/bin/env python
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2024 seeder'
__docformat__ = 'restructuredtext en'

try:
    load_translations()
except NameError:
    pass # load_translations() added in calibre 1.9

import copy
from calibre.utils.config import JSONConfig

STORE_NAME               = 'Options'
MAX_DOWNLOADS            = 'maxDownloads'
MAX_COVERS               = 'maxCovers'
ISSUE_PREFERENCE         = 'issuePreference'
SOURCE_RELEVANCE         = 'sourceRelevance'
SEARCH_WHOLE_TITLE       = 'searchWholeTitle'

AUTHORS_INCLUDE          = 'authorsInclude'
TRANSLATORS_INCLUDE      = 'translatorsInclude'
ILLUSTRATORS_INCLUDE     = 'illustratorsInclude'
LANGUAGE_INCLUDE         = 'languageInclude'
ONE_AUTHOR               = 'oneAuthor'

APPEND_TO_COMMENTS       = 'appendToComments'
APPEND_TO_TAGS           = 'appendToTags'
APPEND_TO_IDENTIFIERS    = 'appendToIdentifiers'
DESCRIPTION              = 'description'
HR                       = 'hr'
PAGES                    = 'pages'
PRINT_RUN                = 'printRun'
ORIGINAL_TITLE           = 'originalTitle'
TITLE                    = 'title'
ORIGINAL_YEAR            = 'originalYear'
PUB_YEAR                 = 'pubYear'
PUBLISHER                = 'publisher'
AUTHORS                  = 'authors'
TRANSLATORS              = 'translators'
ILLUSTRATORS             = 'illustrators'
SERIES                   = 'series'
SERIES_INDEX             = 'seriesIndex'
EDITION                  = 'edition'
EDITION_INDEX            = 'editionIndex'
TAGS                     = 'tags'
RATING                   = 'rating'
RATING5                  = 'rating5'
RATING10                 = 'rating10'
ISBN                     = 'isbn'
XTRANCE                  = 'xtr'
LANGUAGE                 = 'language'
ORIGINAL_LANGUAGE        = 'originalLanguage'
SUBTITLE                 = 'subtitle'
BOOK_DIMENSIONS          = 'bookDimensions'
ORIGINAL_PUBLISHER       = 'originalPublisher'
ISSUE_NUMBER             = 'issueNumber'
IMG_NUMBER               = 'imgNumber'
PUBLICATION_DATE         = 'pubDate'

SWAP_AUTHORS             = 'swapAuthors'
AUTHOR_ROLE              = 'authorRole'

TAGS_MAPPINGS            = 'tagsMappings'
SERIES_MAPPINGS          = 'seriesMappings'
PUBLISHER_MAPPINGS       = 'publisherMappings'
TAGS_FILTER              = 'tagsFilter'
SERIES_FILTER            = 'seriesFilter'
PUBLISHER_FILTER         = 'publisherFilter'
TITLE_LINE               = 'customTitle'
PUBLISHER_LINE           = 'customPublisher'
SERIES_LINE              = 'customSeries'
SERIES_INDEX_FIELD       = 'seriesIndexField'
SERIES_INDEXING_ITEM     = 'seriesIndexingItem'
CUSTOM_TEXT              = 'customText'

DEFAULT_TAGS_MAPPINGS = {
    "Akční": ["Akční"],
    "Akvaristika": ["Akvaristika"],
    "Alchymie": ["Alchymie"],
    "Almanach": ["Almanach"],
    "Alternativní": ["Alternativní"],
    "Alternativní historie": ["Alternativní historie"],
    "Antiutopie": ["Antiutopie"],
    "Antologie": ["Antologie"],
    "Architektura": ["Architektura"],
    "Astrologie": ["Astrologie"],
    "Astronomie a vesmír": ["Astronomie a vesmír"],
    "Auto-moto": ["Auto-moto"],
    "Autobiografie": ["Autobiografie"],
    "Báje a Pověsti": ["Báje a Pověsti"],
    "Bajka": ["Bajka"],
    "Básně v próze": ["Básně v próze"],
    "Biografie": ["Biografie"],
    "Biologie": ["Biologie"],
    "Botanika": ["Botanika"],
    "Bydlení": ["Bydlení"],
    "Cestopis": ["Cestopis"],
    "Cyberpunk": ["Cyberpunk"],
    "Časopis": ["Časopis"],
    "Dark Fantasy": ["Dark Fantasy"],
    "Detektivka": ["Detektivka"],
    "Dětská": ["Dětská"],
    "Dětská encyklopedie": ["Dětská encyklopedie"],
    "Divadelní hra": ["Divadelní hra"],
    "Dívčí románek": ["Dívčí románek"],
    "Dobrodružná": ["Dobrodružná"],
    "Drama": ["Drama"],
    "Drogy a závislosti": ["Drogy a závislosti"],
    "Duchovní nauky": ["Duchovní nauky"],
    "Ekologie": ["Ekologie"],
    "Ekonomie": ["Ekonomie"],
    "Elektrotechnika": ["Elektrotechnika"],
    "Encyklopedie": ["Encyklopedie"],
    "Erotická romance": ["Erotická romance"],
    "Erotika a sex": ["Erotika a sex"],
    "Esej": ["Esej"],
    "Esoterika": ["Esoterika"],
    "Evoluční biologie": ["Evoluční biologie"],
    "Fantaskní": ["Fantaskní"],
    "Fantasy": ["Fantasy"],
    "Fanzin": ["Fanzin"],
    "Fejeton": ["Fejeton"],
    "Feminismus": ["Feminismus"],
    "Filozofie": ["Filozofie"],
    "Foto a video": ["Foto a video"],
    "Fyzika": ["Fyzika"],
    "Gamebook": ["Gamebook"],
    "Geografie": ["Geografie"],
    "Geometrie": ["Geometrie"],
    "Grafika": ["Grafika"],
    "Hacking a cracking": ["Hacking a cracking"],
    "Hardware": ["Hardware"],
    "Historická romance": ["Historická romance"],
    "Historie": ["Historie"],
    "Horor": ["Horor"],
    "Html a WWW": ["Html a WWW"],
    "Hudba": ["Hudba"],
    "Humor": ["Humor"],
    "Chemie": ["Chemie"],
    "Chovatelství": ["Chovatelství"],
    "Indiánka": ["Indiánka"],
    "Interview": ["Interview"],
    "Jazyky": ["Jazyky"],
    "Jiná": ["Jiná"],
    "Jiná odborná": ["Jiná odborná"],
    "Klima, počasí": ["Klima; počasí"],
    "Komiks": ["Komiks"],
    "Kreslení a malířství": ["Kreslení a malířství"],
    "Krimi": ["Krimi"],
    "Kuchařka": ["Kuchařka"],
    "Kultura a umění": ["Kultura a umění"],
    "Kursy a testy": ["Kursy a testy"],
    "Léčitelství": ["Léčitelství"],
    "Lékařský thriller": ["Lékařský thriller"],
    "Letectví a kosmonautika": ["Letectví a kosmonautika"],
    "Literární věda": ["Literární věda"],
    "Literatura faktu": ["Literatura faktu"],
    "LitRPG": ["LitRPG"],
    "Magie": ["Magie"],
    "Management": ["Management"],
    "Mapy": ["Mapy"],
    "Mapy a plány": ["Mapy a plány"],
    "Marketing": ["Marketing"],
    "Matematika": ["Matematika"],
    "Medicína": ["Medicína"],
    "Memoáry": ["Memoáry"],
    "Meteorologie": ["Meteorologie"],
    "Military SF": ["Military SF"],
    "Modelářství": ["Modelářství"],
    "Mytologie": ["Mytologie"],
    "Náboženství, víra, sekty": ["Náboženství; víra; sekty"],
    "Napětí": ["Napětí"],
    "Naučná": ["Naučná"],
    "New Weird": ["New Weird"],
    "Novela": ["Novela"],
    "Okultní": ["Okultní"],
    "Osobní rozvoj": ["Osobní rozvoj"],
    "Outdoor - Survival": ["Outdoor - Survival"],
    "Paleontologie": ["Paleontologie"],
    "Paranormal romance": ["Paranormal romance"],
    "Parodie": ["Parodie"],
    "PC Hra": ["PC Hra"],
    "Pedagogika": ["Pedagogika"],
    "Personalistika": ["Personalistika"],
    "Pěstitelství": ["Pěstitelství"],
    "Počítače": ["Počítače"],
    "Počítačové sítě": ["Počítačové sítě"],
    "Poezie": ["Poezie"],
    "Pohádky": ["Pohádky"],
    "Politika": ["Politika"],
    "Postkatastrofická": ["Postkatastrofická"],
    "Povídky": ["Povídky"],
    "Povinná četba": ["Povinná četba"],
    "Právo": ["Právo"],
    "Pro mládež": ["Pro mládež"],
    "Pro ženy": ["Pro ženy"],
    "Programování": ["Programování"],
    "Průvodce": ["Průvodce"],
    "Příroda": ["Příroda"],
    "Příručka, návod": ["Příručka; návod"],
    "Psychologie": ["Psychologie"],
    "Ročenka": ["Ročenka"],
    "Román": ["Román"],
    "Román autobiografický": ["Román autobiografický"],
    "Román detektivní": ["Román detektivní"],
    "Román historický": ["Román historický"],
    "Román milostný": ["Román milostný"],
    "Román profesní": ["Román profesní"],
    "Román protiválečný": ["Román protiválečný"],
    "Román psychologický": ["Román psychologický"],
    "Román společenský": ["Román společenský"],
    "Román utopický": ["Román utopický"],
    "Román válečný": ["Román válečný"],
    "Román ze soudního prostředí": ["Román ze soudního prostředí"],
    "Romaneto": ["Romaneto"],
    "Romantické": ["Romantické"],
    "Rozhlasová hra": ["Rozhlasová hra"],
    "Ruční práce": ["Ruční práce"],
    "Řemesla a hobby": ["Řemesla a hobby"],
    "Sága": ["Sága"],
    "Satira": ["Satira"],
    "Sběratelství": ["Sběratelství"],
    "Sbírka": ["Sbírka"],
    "Sborník": ["Sborník"],
    "Scénář": ["Scénář"],
    "Sci-fi": ["Sci-fi"],
    "Slovník": ["Slovník"],
    "Sociologie": ["Sociologie"],
    "Software manuál": ["Software manuál"],
    "Space Opera": ["Space Opera"],
    "Sport": ["Sport"],
    "Stavby": ["Stavby"],
    "Steampunk": ["Steampunk"],
    "Strojírenství": ["Strojírenství"],
    "Symbologie": ["Symbologie"],
    "Šachy": ["Šachy"],
    "Špionážní": ["Špionážní"],
    "Technická norma": ["Technická norma"],
    "Technika": ["Technika"],
    "Technothriller": ["Technothriller"],
    "Thriller": ["Thriller"],
    "Turistika": ["Turistika"],
    "Učebnice": ["Učebnice"],
    "Umění": ["Umění"],
    "Urban fantasy": ["Urban fantasy"],
    "Veterina": ["Veterina"],
    "Vojenská": ["Vojenská"],
    "Výbor z díla": ["Výbor z díla"],
    "Výchova": ["Výchova"],
    "Vystřihovánka": ["Vystřihovánka"],
    "Výživa": ["Výživa"],
    "Western": ["Western"],
    "Zabezpečení sítí, firewaly": ["Zabezpečení sítí; firewaly"],
    "Záhady a tajemno": ["Záhady a tajemno"],
    "Zdraví": ["Zdraví"],
    "Zoologie": ["Zoologie"],
    "Životní prostředí": ["Životní prostředí"],
    "Životní styl": ["Životní styl"],
    "Žurnalistika": ["Žurnalistika"],
}

DEFAULT_STORE_VALUES = {
    MAX_DOWNLOADS: 10,
    MAX_COVERS: 1,
    ISSUE_PREFERENCE: 0,
    SEARCH_WHOLE_TITLE: False,
    AUTHORS_INCLUDE: True,
    TRANSLATORS_INCLUDE: False,
    ILLUSTRATORS_INCLUDE: False,
    LANGUAGE_INCLUDE: 0,
    APPEND_TO_COMMENTS: [
        (DESCRIPTION, True, _('Description')),
    ],
    APPEND_TO_TAGS: [
        (TAGS, True, _('Tags'))
    ],
    APPEND_TO_IDENTIFIERS: [
        (XTRANCE, True, _('Identifier xtrance'), 'xtrance'),
        (ISBN, True, _('ISBN'), 'isbn')
    ],
    PUBLICATION_DATE: 0,
    SWAP_AUTHORS: False,
    AUTHOR_ROLE: False,
    ONE_AUTHOR: False,
    TAGS_FILTER: False,
    SERIES_FILTER: False,
    PUBLISHER_FILTER: False,
    PUBLISHER_LINE: [
        (PUBLISHER, True, _('Publisher')),
    ],
    TITLE_LINE: [
        (TITLE, True, _('Title')),
    ],
    SERIES_LINE: [
        (SERIES, True, _('Series')),
    ],
    SERIES_INDEX_FIELD: (SERIES_INDEX, True, _('Series index')),
    SERIES_INDEXING_ITEM: 0,
    SERIES_MAPPINGS: {},
    TAGS_MAPPINGS: copy.deepcopy(DEFAULT_TAGS_MAPPINGS),
    PUBLISHER_MAPPINGS: {}
}

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig('plugins/xtrance')

# Set defaults
plugin_prefs.defaults[STORE_NAME] = DEFAULT_STORE_VALUES

def get_pref(option):
    c = plugin_prefs[STORE_NAME]
    default_value = plugin_prefs.defaults[STORE_NAME][option]
    return c.get(option, default_value)

def get_prefs(fill_defaults=False):
    if fill_defaults:
        c = get_store_prefs(plugin_prefs)
    else:
        c = plugin_prefs[STORE_NAME]
    return c

def get_plugin_pref(store_name, option):
    c = plugin_prefs[store_name]
    default_value = plugin_prefs.defaults[store_name][option]
    return c.get(option, default_value)

def get_plugin_prefs(store_name, fill_defaults=False):
    if fill_defaults:
        c = get_prefs_orig(plugin_prefs, store_name)
    else:
        c = plugin_prefs[store_name]
    return c

def get_store_prefs(prefs_store):
    store = {}
    if prefs_store and prefs_store[STORE_NAME]:
        for key in plugin_prefs.defaults[STORE_NAME].keys():
            store[key] = prefs_store[STORE_NAME].get(key, plugin_prefs.defaults[STORE_NAME][key])
    else:
        store = plugin_prefs.defaults[STORE_NAME]
    return store

def get_prefs_orig(prefs_store, store_name):
    store = {}
    if prefs_store and prefs_store[store_name]:
        for key in plugin_prefs.defaults[store_name].keys():
            store[key] = prefs_store[store_name].get(key, plugin_prefs.defaults[store_name][key])
    else:
        store = plugin_prefs.defaults[store_name]
    return store
