﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace ConvertIMPGUI
{
    public partial class frmRenameProgress : Form
    {
        private string _IMPDirectory = "";

        public frmRenameProgress()
        {
            InitializeComponent();
        }

        private void frmRenameProgress_Load(object sender, EventArgs e)
        {
            StartProcess();
        }

        public string IMPDirectory
        {
            set { _IMPDirectory = value; }
        }

        public void StartProcess()
        {
            Cursor = Cursors.WaitCursor;
            Application.DoEvents();

            string[] files = Directory.GetFiles(_IMPDirectory, "*.imp");

            fileProgress.Minimum = 0;
            fileProgress.Maximum = files.Length;
            fileProgress.Value = 0;

            foreach (string file in files)
            {
                CIMPFile imp = new CIMPFile(file);
                frmProgress frm = new frmProgress();
                frm.IMPFile = imp;
                frm.Show();
                Application.DoEvents();
                frm.StartProcessing();
                imp = frm.IMPFile;
                frm.Close();
                frm.Dispose();
                frm = null;

                string newFileName = imp.BookProperties.FirstName + " - " + imp.BookProperties.Title;

                newFileName = newFileName.Replace("/", " ");
                newFileName = newFileName.Replace(@"\", " ");
                newFileName = newFileName.Replace(":", " ");
                newFileName = newFileName.Replace("?", " ");
                newFileName = newFileName.Replace("*", " ");
                newFileName = newFileName.Replace("<", " ");
                newFileName = newFileName.Replace(">", " ");
                newFileName = newFileName.Replace("|", " ");

                string newFilePath = file.Substring(0, file.LastIndexOf(@"\") + 1) + newFileName + ".imp";

                lblNewFileName.Text = newFilePath;
                fileProgress.Value = fileProgress.Value + 1;
                lblProgress.Text = fileProgress.Value + " of " + fileProgress.Maximum;
                Application.DoEvents();

                if (file.ToLower() != newFilePath.ToLower())
                {
                    try
                    {
                        File.Copy(file, newFilePath, true);
                        File.Delete(file);
                    }
                    catch 
                    {
                        System.Diagnostics.Debug.WriteLine("ERROR: " + file);
                    }
                }
            }

            Cursor = Cursors.Default;
            Application.DoEvents();
        }
    }
}
