﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;

namespace ConvertIMPGUI
{
    #region public class IMPHeader
    public class IMPHeader
    {
        public int version = 0;
        public int impType = 0;
        public string constant = "";
        public string unknown = "";
        public int fileCount = 0;
        public int directoryLength = 0;
        public int bytesRemaining = 0;
        public string unknown2 = "";
        public string unknown3 = "";
        public bool compression = false;
        public bool encryption = false;
        public int zoomState = 0;
        public string unknown4 = "";
        public string impTypeDevice = "";

        #region ToString
        public override string ToString()
        {
            string _toString = "";

            _toString += "Version = " + version + "\n";
            _toString += "Constant = " + constant + "\n";
            _toString += "FileCount = " + fileCount.ToString() + "\n";
            _toString += "DictionaryLength = " + directoryLength.ToString() + "\n";
            _toString += "BytesRemainingInHeader = " + bytesRemaining.ToString() + "\n";
            _toString += "Compression = " + compression.ToString() + "\n";
            _toString += "Encryption = " + encryption.ToString() + "\n";
            _toString += "ZoomState = " + zoomState.ToString() + "\n";
            _toString += "Unknown = " + unknown.Trim() + "\n";
            _toString += "Unknown = " + unknown2.Trim() + "\n";
            _toString += "Unknown = " + unknown3.Trim() + "\n";
            _toString += "Unknown = " + unknown4.Trim() + "\n";

            return _toString;
        }
        #endregion
    }
    #endregion

    #region public class IMPBookProperties
    public class IMPBookProperties
    {
        public string ID = "";
        public string Bookshelf_Category = "";
        public string Subcategory = "";
        public string Title = "";
        public string LastName = "";
        public string MiddleName = "";
        public string FirstName = "";
        public string ResFile = "";
        public int Length = 0;

        #region ToString
        public override string ToString()
        {
            string _toString = "";

            _toString += "ID = " + ID + "\n";
            _toString += "Bookshelf_Category = " + Bookshelf_Category + "\n";
            _toString += "Subcategory = " + Subcategory + "\n";
            _toString += "Title = " + Title + "\n";
            _toString += "LastName = " + LastName + "\n";
            _toString += "MiddleName = " + MiddleName + "\n";
            _toString += "FirstName = " + FirstName + "\n";
            _toString += "ResFile = " + ResFile + "\n";

            return _toString;
        }
        #endregion
    }
    #endregion

    #region public class IMPTableContents
    public class IMPTableContents
    {
        public List<IMPTableContentsItem> table = new List<IMPTableContentsItem>();
    }
    #endregion

    #region public class IMPTableContentsItem
    public class IMPTableContentsItem
    {
        public string fileName = "";
        public int fileSize = 0;
        public string fileType = "";
        public int indexes = 0;

        #region ToString
        public override string ToString()
        {
            string _toString = "";

            _toString += "FileName = " + fileName + "\n";
            _toString += "FileSize = " + fileSize.ToString() + "\n";
            _toString += "FileType = " + fileType + "\n";

            return _toString;
        }
        #endregion
    }
    #endregion

    #region public class IMPRESFiles
    public class IMPRESFiles
    {
        public List<IMPRESFile> list = new List<IMPRESFile>();
    }
    #endregion

    #region public class IMPRESFile
    public class IMPRESFile
    {
        public string fileName = "";
        public int fileSize = 0;
        public string fileType = "";
        public int currentPosition = 0;
        public byte[] buffer = null;

        #region ToString
        public override string ToString()
        {
            string _toString = "";

            _toString += "FileName = " + fileName + "\n";
            _toString += "FileSize = " + fileSize.ToString() + "\n";
            _toString += "FileType = " + fileType + "\n";

            return _toString;
        }
        #endregion
    }
    #endregion

    #region public class SWIndex
    public class SWIndex
    {
        public int sequenceNumber = 0;
        public int offsetToStartOfIndex = 0;
        public int lengthOfIndex = 0;
        public string fileType = "";
    }
    #endregion

    #region public class CMInfo
    public class CMInfo
    {
        public int Index1 = 0;
        public int Index2 = 0;
        public int RecordLength1 = 0;
        public int RecordLength2 = 0;
        public int OffsetToStartOfRecord1 = 0;
        public int OffsetToStartOfRecord2 = 0;

        public int UncompressedDataPosition = 0;
        public int CompressedDataPosition = 0;
        public int bitPosPastBytePosInCompressedData = 0;
    }
    #endregion

    #region public class CMIndex
    public class CMIndex
    {
        public int UncompressedDataPosition = 0;
        public int CompressedDataPosition = 0;
        public int bitPosPastBytePosInCompressedData = 0;
    }
    #endregion

    #region public class IMGRunItem
    public class IMGRunItem
    {
        public int unknown1 = 0; // UNKNOWN
        public int imageWidth = 0; // Image Width
        public int imageHeight = 0; // ImageHeight
        public int unknown2 = 0; // UNKNOWN
        public int unknown3 = 0; // UNKNOWN
        public int dataOffset = 0; // offset within file DATA.FRK of control character 0x0F for this image
        public int unknown4 = 0; // UNKNOWN
        public string imageFileType = "";
        public int imageID = 0;
        public IMPRESFile dataFile = null;
        public Image Image = null;
        public string imageFileName = "";
    }
    #endregion

    #region IMPStyleRunItem
    public class IMPStyleRunItem
    {
        public int StyleIndex = 0;
        public int Offset = 0;
    }
    #endregion

    #region IMPStyleItem
    public class IMPStyleItem
    {
        public string element = "";
        public string fontFamily = "";
        public string fontFamilyName = "";
        public string style = "";
        public string fontSize = "";
        public int fontRealSize = 0;
        public string textAlign = "";
        public int textColorRed = 0;
        public int textColorGreen = 0;
        public int textColorBlue = 0;
        public Color textColor = Color.Black;
        public int textBGColorRed = 0;
        public int textBGColorGreen = 0;
        public int textBGColorBlue = 0;
        public Color textBGColor = Color.White;
        public int marginTop = 0;
        public int textIndent = 0;
        public int marginRight = 0;
        public int marginLeft = 0;
        public int oebColumnNumber = 0;

        public override string ToString()
        {
            string ret = "";

            ret += "Element = " + element + "\n";
            ret += "FontFamilyName = " + fontFamilyName + "\n";
            ret += "Style = " + style + "\n";
            ret += "FontRealSize = " + fontRealSize + "\n";
            ret += "TextAlign = " + textAlign + "\n";

            return ret;
        }
    }
    #endregion

    #region IMPExtendedStyleItem
    public class IMPExtendedStyleItem
    {
        public string content = "";

        public string Resource1 = "";
        public string Resource2 = "";
        public string OrphanPull = "";
        public string WidowPush = "";
    }
    #endregion

    #region IMPResource
    public class IMPResource
    {
        public int id = 0;
        public int index = 0;
        public int length = 0;
        public int offset = 0;

        public int Resource1A = 0;
        public int Resource1B = 0;
        public int Resource1C = 0;
    }
    #endregion

    #region IMPPPic
    public class IMPPPic
    {
        public int CountOfCellAndTableBorders = 0;
        public int CountOfImages = 0;
        //public bool HasBorders = false;
        //public bool HasPictures = false;
    }
    #endregion

    #region IMPPcZ1
    public class IMPPcZ1
    {
        public string View = "";
        public int BorderLeftPosition = 0;
        public int BorderTopPosition = 0;
        public int Width = 0;
        public int Height = 0;

        public int ID = 0;
        public int Length = 0;
        public int Offset = 0;
    }
    #endregion

    #region IMPTableItem
    public class IMPTableItem
    {
        public string Align = "";
        public string AlignType = "";
        public int Width = 0;
        public int Border = 0;
        public int CellSpacing = 0;
        public int CellPadding = 0;
        public bool CaptionPresent = false;
        public int CaptionLength = 0;
        public string ListStyleType = "";
        public int TRowID = 0;
    }
    #endregion

    #region IMPTableRowGroup
    public class IMPTableRowGroup
    {
        public int RowID = 0;
        public List<IMPTableRowItem> Rows = new List<IMPTableRowItem>();
    }
    #endregion

    #region IMPTableRowItem
    public class IMPTableRowItem
    {
        public int TRowID = 0;
        public string RowType = "";
        public int Border = 0;
        public int TCelID = 0;
        public int Offset = 0;
        public int Length = 0;

        public int val1 = 0;
        public int val2 = 0;
        public int val3 = 0;
        public int val4 = 0;
        public int val5 = 0;
        public int val6 = 0;
        public int val7 = 0;
        public int val8 = 0;
        public int val9 = 0;
        public int val10 = 0;
        public int val11 = 0;
        public int val12 = 0;
        public int val13 = 0;
        public int val14 = 0;
        public int val15 = 0;
        public int val16 = 0;
        public int val17 = 0;
        public int val18 = 0;
        public int val19 = 0;
        public int val20 = 0;
        public int val21 = 0;
        public int val22 = 0;
    }
    #endregion

    #region IMPTableCellGroup
    public class IMPTableCellGroup
    {
        public int CellID = 0;
        public List<IMPTableCellItem> Cells = new List<IMPTableCellItem>();
    }
    #endregion

    #region IMPTableCellItem
    public class IMPTableCellItem
    {
        public int TCelID = 0;
        public string CellType = "";
        public string VerticalAlign = "";
        public int Width = 0;
        public int Height = 0;
        public int Offset = 0;
        public int Length = 0;
        public int BGColorRed = 0;
        public int BGColorGreen = 0;
        public int BGColorBlue = 0;
        public Color BGColor = Color.White;

        public int val1 = 0;
        public int val2 = 0;
        public int val3 = 0;
        public int val4 = 0;
        public int val5 = 0;
        public int val6 = 0;
    }
    #endregion

    public class IMPBPgzItem
    {

    }
}
