# awk script
# install newLister in start.sh
# the original invocation of contenLister is flagged 
# to de-install it later...

function start_lister(original) {
   $0 = original
   cmd = "newLister"
   if (items > 4 && items < 21) {
     cmd = "newLister --items " items
   }
   printf "#CONTENTLISTER: %s\n",original
   printf "%-60s #NEWLISTER\n", "if [ -x /usr/bin/newLister ]; then"
   sub(/contentLister/, cmd)
   printf "  %-58s #NEWLISTER\n", $0
   printf "%-60s #NEWLISTER\n", "else"
   printf "  %-58s #NEWLISTER\n", original
   printf "%-60s #NEWLISTER\n", "fi"
}

# re-install in a script we edited earlier
/#CONTENTLISTER: / {
   sub(/#CONTENTLISTER: /, "");
   start_lister($0)
   next
}

# ignore lines that we have added ourselves
/#NEWLISTER/ {next}

# install in original script
/\/usr\/bin\/contentLister/ {
   start_lister($0)
   next
}

#other lines are not modified...
{print}

