#!/bin/sh
scriptdir=`/usr/bin/dirname $0`
cd $scriptdir

# this function will be executed in ../_files 
do_it() {
  echo "Copy files..."
  cp newcursor.png newLister.rc /usr/share/contentlister/
  cp newLister /usr/bin/
  chmod +x /usr/bin/newLister

  if [ ! -x $START ]; then
    STATUS="$START: no such script"
    return 1
  fi

  if ! grep -q /usr/bin/contentLister $START; then
    STATUS="No contentLister in $START"
    return 1
  fi

  echo "Edit start script..."
  awk -f newLister_install.awk $START >$START.tmp
  chmod +x $START.tmp
  mv $START.tmp $START
  STATUS='newLister has been installed'
  return 0
}
. ../_files/run_common.sh
