#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2020, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

import re, io, sys
import inspect

from qt.core import (QVBoxLayout, QHBoxLayout, QLabel, QFontMetrics,
                     QSize)

from calibre import prints
from calibre.constants import DEBUG
from calibre.gui2 import error_dialog
from calibre.gui2.complete2 import EditWithComplete
from calibre.gui2.dialogs.confirm_delete import confirm
from calibre.gui2.tweak_book.widgets import Dialog
from calibre.gui2.tweak_book.editor.text import TextEdit

from calibre_plugins.editor_chains.modules import compile_code

try:
    load_translations()
except NameError:
    prints("EditorChains::code_editor.py - exception when loading translations")

class CodeEditor(Dialog):
    def __init__(self, mod_name='', parent=None, language='python',
                 template='', show_name=True):
        self._mod_name = mod_name
        self.template = template
        self.language = language
        self.show_name = show_name
        Dialog.__init__(self, _('Create/edit a module'), 'editor-chains-edit-mods', parent=parent)

    def setup_ui(self):
        self.l = l = QVBoxLayout(self)
        self.h = h = QHBoxLayout()
        l.addLayout(h)

        self.la1 = la = QLabel(_('M&odule name:'))
        h.addWidget(la)
        self.fb = fb = EditWithComplete(self)
        la.setBuddy(fb)
        h.addWidget(fb, stretch=10)
        if not self.show_name:
            self.la1.hide()
            self.fb.hide()

        self.la3 = la = QLabel(_('&Code:'))
        self.source_code = TextEdit(self)
        self.source_code.load_text(self.template, self.language)
        la.setBuddy(self.source_code)
        l.addWidget(la), l.addWidget(self.source_code)

#        if self._mod_name:
#            self.fb.setText(self._mod_name)
#            self.source_code.setPlainText(self.module_sources.get(self._mod_name) or self.template)
#        #else:
#            #self.source_code.setPlainText(self.template)

        self.la2 = la = QLabel()
        la.setOpenExternalLinks(True)
        l.addWidget(la)

        l.addWidget(self.bb)

    def sizeHint(self):
        fm = QFontMetrics(self.font())
        return QSize(fm.averageCharWidth() * 120, 600)

    @property
    def mod_name(self):
        return self.fb.text().strip()

    @property
    def source(self):
        return self.source_code.toPlainText()

    def accept(self):
#        if not self.mod_name:
#            return error_dialog(self, _('Must specify name'), _(
#                'You must specify a name for this module.'), show=True)
        source = self.source
        if self.language == 'python':
            try:
                mod = compile_code(source, self.mod_name)
            except Exception as err:
                return error_dialog(self, _('Invalid Python code'), _(
                    'The code you created is not valid Python code, with error: %s') % err, show=True)

        Dialog.accept(self)
