#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2022, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from qt.core import (QApplication, Qt, QWidget, QVBoxLayout,
                     QCheckBox, QLabel)

from calibre import prints
from calibre.constants import DEBUG
from calibre.ebooks.oeb.polish.main import tweak_polish
from calibre.ebooks.oeb.polish.main import CUSTOMIZATION

from calibre_plugins.editor_chains.actions.base import EditorAction

try:
    load_translations()
except NameError:
    prints("EditorChains::actions/upgrade_internals.py - exception when loading translations")

class ConfigWidget(QWidget):
    def __init__(self, plugin_action, chain_name, chains_config, *args, **kwargs):
        QWidget.__init__(self)
        self.plugin_action = plugin_action
        self.chain_name = chain_name
        self.chains_config = chains_config
        self._init_controls()

    def _init_controls(self):

        l = self.l = QVBoxLayout()
        self.setLayout(l)

        self.remove_ncx = QCheckBox(_('Remove the legacy Table of Contents in NCX form'))
        l.addWidget(self.remove_ncx)

        l.addStretch(1)

        self.setMinimumSize(300,100)

    def load_settings(self, settings):
        if settings:
            customization = settings['customization']
            self.remove_ncx.setChecked(customization['remove_ncx'])

    def save_settings(self):
        settings = {}
        settings['customization'] = CUSTOMIZATION.copy()
        settings['customization']['remove_ncx'] = self.remove_ncx.isChecked()
        return settings

class UpgradeInternals(EditorAction):

    name = 'Upgrade Book Internals'
    _is_builtin_ = True
    headless = True

    def run(self, chain, settings, *args, **kwargs):
        action = 'upgrade_book'
        customization = settings.get('customization', None)
        if customization is None:
            return
        report, changed = tweak_polish(chain.current_container, {action:True}, customization=customization)

    def validate(self, settings):
        if settings.get('customization') is None:
            return _('No settings'), _('You must first configure this action')
        return True

    def config_widget(self):
        return ConfigWidget

