#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2022, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from qt.core import (QApplication, Qt, QWidget, QVBoxLayout,
                     QCheckBox, QLabel)

from calibre import prints
from calibre.constants import DEBUG
from calibre.gui2 import error_dialog
from calibre.ebooks.css_transform_rules import transform_container
from calibre.gui2.css_transform_rules import RulesDialog

from calibre_plugins.editor_chains.actions.base import EditorAction

try:
    load_translations()
except NameError:
    prints("EditorChains::actions/transform_styles.py - exception when loading translations")

class ConfigDialog(RulesDialog):

    DIALOG_TITLE = _('Edit tag mapper rules')
    PREFS_NAME = 'ec-edit-tag-mapper-rules'

    def __init__(self, parent, plugin_action, action, name, title):
        RulesDialog.__init__(self)
        self.plugin_action = plugin_action
        self.action = action

    def load_settings(self, settings):
        if settings:
            self.rules = settings['last_used_transform_rules']

    def save_settings(self):
        settings = {}
        settings['last_used_transform_rules'] = self.rules
        return settings

    def accept(self):
        self.settings = self.save_settings()
        # validate settings
        is_valid = self.action.validate(self.settings)
        if is_valid is not True:
            msg, details = is_valid
            error_dialog(
                self,
                msg,
                details,
                show=True
            )
            return
        RulesDialog.accept(self)

class TransformStyles(EditorAction):

    name = 'Transform Styles'
    _is_builtin_ = True
    headless = True

    def run(self, chain, settings, *args, **kwargs):
        last_used_transform_rules = settings['last_used_transform_rules']
        changed = transform_container(chain.current_container, last_used_transform_rules)

    def validate(self, settings):
        return True

    def config_widget(self):
        return ConfigDialog

