#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2022, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from qt.core import (QApplication, Qt, QWidget, QVBoxLayout,
                     QCheckBox, QLabel)

from calibre import prints
from calibre.constants import DEBUG
from calibre.gui2 import error_dialog
from calibre.ebooks.html_transform_rules import transform_container
from calibre.gui2.html_transform_rules import RulesDialog
from calibre.ebooks.oeb.polish.container import OEB_DOCS
from calibre.gui2.tweak_book import editors

from calibre_plugins.editor_chains.actions.base import EditorAction
from calibre_plugins.editor_chains.scope import scope_names, ScopeWidget, validate_scope, scope_is_headless

try:
    load_translations()
except NameError:
    prints("EditorChains::actions/transform_transform.py - exception when loading translations")

class ConfigDialog(RulesDialog):

    DIALOG_TITLE = _('Edit tag mapper rules')
    PREFS_NAME = 'ec-edit-tag-mapper-rules'

    def __init__(self, parent, plugin_action, action, name, title):
        RulesDialog.__init__(self)
        self.plugin_action = plugin_action
        self.action = action

    def load_settings(self, settings):
        if settings:
            self.rules = settings['last_used_transform_rules']
            scope = settings.get('where')
            if scope:
                self.transform_scope = scope

    def save_settings(self):
        settings = {}
        settings['last_used_transform_rules'] = self.rules
        settings['where'] = self.transform_scope
        return settings

    def accept(self):
        self.settings = self.save_settings()
        # validate settings
        is_valid = self.action.validate(self.settings)
        if is_valid is not True:
            msg, details = is_valid
            error_dialog(
                self,
                msg,
                details,
                show=True
            )
            return
        RulesDialog.accept(self)

class TransformHTML(EditorAction):

    name = 'Transform HTML'
    _is_builtin_ = True
    headless = True

    def run(self, chain, settings, *args, **kwargs):
        last_used_transform_rules = settings['last_used_transform_rules']
        scope = settings.get('where', 'all')
        names = ()
        mime_map = chain.current_container.mime_map
        if scope == 'current':
            if not chain.boss.currently_editing or mime_map.get(chain.boss.currently_editing) not in OEB_DOCS:
                prints('Transform HTML: Not currently editing an HTML file')
                return
            names = (chain.gui.boss.currently_editing,)
        elif scope == 'open':
            names = tuple(name for name in editors if mime_map.get(name) in OEB_DOCS)
            if not names:
                prints('Transform HTML: Not currently editing any HTML files')
                return
        elif scope == 'selected':
            names = tuple(name for name in chain.gui.file_list.file_list.selected_names if mime_map.get(name) in OEB_DOCS)
            if not names:
                prints('Transform HTML: No HTML files are currently selected in the File browser')
                return
        changed = transform_container(chain.current_container, last_used_transform_rules, names=names)
        #if changed:
            #report = _('Transform HTML: Changed some elements.')
        #else:
            #report = _('No changes: No HTML was changed.')
        #chain.add_to_report(repot)

    def validate(self, settings):
        return True

    def config_widget(self):
        return ConfigDialog

    def is_headless(self, settings):
        scope = settings.get('where', 'all')
        return scope_is_headless(scope)
