#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2021, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

import re

from calibre import prints
from calibre.constants import DEBUG
from calibre.ebooks.html_transform_rules import unwrap_tag
from calibre.ebooks.oeb.base import XHTML, XPNSMAP, barename, etree

from calibre_plugins.editor_chains.actions.tag_actions.actions.base import ElementAction

try:
    load_translations()
except NameError:
    prints("EditorChains::actions/tag_actions/actions/unwrap.py - exception when loading translations")

class UnwrapAction(ElementAction):

    name = 'Unwrap'
    
    def run(self, chain, number, elements, settings, context, *args, **kwargs):
        for element in elements:
            unwrap_tag(element)
 
