#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~
__license__ = 'GPL v3'
__copyright__ = '2021, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from qt.core import (QApplication, Qt, QWidget, QGridLayout, QHBoxLayout, QVBoxLayout,
                     QGroupBox, QCheckBox)

from calibre import prints
from calibre.constants import DEBUG
from calibre.ebooks.html_transform_rules import remove_tag

from calibre_plugins.editor_chains.actions.tag_actions.actions.base import ElementAction

try:
    load_translations()
except NameError:
    prints("EditorChains::actions/tag_actions/actions/decompose.py - exception when loading translations")

class DeleteAction(ElementAction):

    name = 'Delete'
    
    def run(self, chain, number, elements, settings, context, *args, **kwargs):
        for element in elements:
            remove_tag(element)
