#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2020, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

import copy


from calibre import prints
from calibre.constants import DEBUG
from calibre.gui2 import error_dialog

class ElementAction(object):

    # Actions must have a unique name attribute.
    name = 'Element Action'

    '''
    This is the base class for all actions
    '''
    def __init__(self, plugin_action):
        '''
        All actions are intialized at startup
        The are re-initialized on adding or modifying custom modules
        '''
        self.plugin_action = plugin_action

    def run(self, chain, number, elements, settings, context, *args, **kwargs):
        raise NotImplementedError

    def config_widget(self):
        '''
        If you want your filter to have settings widget, implement this method
        This should return a Qwidget (not dialog) with the following methods:
        [*] __init__(self, plugin_action)
        [*] save_settings(settings)
                This method is used to save the settings from the widget
                it should return a dictionary containing all the settings
        [*] load_settings(self, settings)
                This method is used to load the saved settings into the
                widget
        '''
        return None

    def validate(self, settings):
        '''
        Validate settings dict. This is called when you press the OK button in config dialog.
        changes are applied only if the this methods returns True.
        It is called also when verifying the chain validity on before running.
        If the setting in the dictionary are not valid, return a tuple
        of two strings (message, details), these will be displayed as a warning dialog to
        the user and the process will be aborted.
        '''
        return True


    def pre_run(self, chain, settings, context):
        '''
        Will be called before iterating over matched elements and to call self.run()
        '''
        pass

    def post_run(self, chain, settings, context):
        '''
        Will be called after iterating over matched elements and to call self.run()
        '''
        pass

    def default_settings(self):
        '''
        default settings to be used if no settings are configured
        '''
        return {}




