#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2021, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from functools import partial
from collections import OrderedDict, defaultdict
import copy
import builtins

from calibre import prints
from calibre.constants import DEBUG
from calibre.gui2 import error_dialog

from calibre_plugins.editor_chains.actions.style_actions.filters.base import StyleFilter
from calibre_plugins.editor_chains.actions.tag_actions.filters.group import GroupWidget as ParentGroupWidget


try:
    load_translations()
except NameError:
    prints("EditorChains::actions/style_actions/filters/group.py - exception when loading translations")


class GroupWidget(ParentGroupWidget):
    def __init__(self, parent, plugin_action, filter_, *args, **kwargs):
        self.identifier = kwargs.get('identifier')
        self.allow_subgroups = True
        if isinstance(parent, GroupWidget):
            self.allow_subgroups = False
        self.parent = parent
        self.filter_ = filter_
        self.plugin_action = plugin_action
        self.filters = self.plugin_action.actions['Style Actions'].filters
        self.match_dict = {
            'Match all': 'all',
            'Match any': 'any'
        }
        self._init_controls()

class GroupFilter(StyleFilter):

    name = 'Group'
    
    def evaluate(self, chain, element, settings, context, *args, **kwargs):
        arg_list = []
        match_opt = settings['config']['match_opt']
        func = builtins.__dict__.get(match_opt)
        filters = self.plugin_action.actions['Style Actions'].filters
        for filter_config in settings.get('config', {}).get('filters_config', {}):
            name = filter_config['name']
            filter_ = filters.get(name)
            if filter_:
                res = filter_.evaluate(chain, element, filter_config['config'], context)
                arg_list.append(res)
                #filter_config['result'] = res
        return func(arg_list)

    def validate(self, settings):
        if not settings:
            return (_('Group Filter Error'), _('You must configure this filter'))
        all_errors = []
        filters_config = settings.get('config', {}).get('filters_config', {})
        if not filters_config:
            return (_('Group Filter Error'), _('You must at least add one filter to the group'))
        for filter_config in filters_config:
            name = filter_config['name']
            filters = self.plugin_action.actions['Style Actions'].filters
            filter_ = filters.get(name)
            if filter_:
                res = filter_.validate(filter_config['config'])
                if res is not True:
                    all_errors.append(': '.join(list(res)))
            else:
                all_errors.append(_(f'Filter Error: cannot find filter with the name ({name})'))
        if all_errors:
            return _('Group Filter Error'), '\n'.join(all_errors)
        return True

    def filter_widget(self):
        return GroupWidget
