#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2022, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

import regex

from qt.core import (QApplication, Qt, QWidget, QGridLayout, QHBoxLayout, QVBoxLayout,
                     QLabel, QLineEdit)

from calibre import prints
from calibre.constants import DEBUG
from calibre.gui2 import error_dialog
from calibre.ebooks.css_transform_rules import all_properties

from calibre_plugins.editor_chains.actions.style_actions.actions.base import StyleAction

try:
    load_translations()
except NameError:
    prints("EditorChains::actions/style_actions/filters/delete_prop.py - exception when loading translations")


class ActionWidget(QWidget):
    def __init__(self, plugin_action, action):
        QWidget.__init__(self)
        self.plugin_action = plugin_action
        self.action = action
        self._init_controls()

    def _init_controls(self):

        l = self.l = QGridLayout()
        self.setLayout(l)

        name_lbl = QLabel(_('Property Name'))
        l.addWidget(name_lbl, 0, 0, 1, 1)
        self.name_edit = QLineEdit()
        self.name_edit.setToolTip(_('Property name e.g. margin-top, text-indent, .... etc, supports regex expressions e.g. margin.*'))
        l.addWidget(self.name_edit, 0, 1, 1, 1)

        l.setRowStretch(l.rowCount(), 1)
        self.setMinimumSize(400,100)

    def load_settings(self, settings):
        if settings:
            self.name_edit.setText(settings['name'])

    def save_settings(self):
        settings = {}
        settings['name'] = self.name_edit.text()
        return settings


class DeletePropertiesAction(StyleAction):

    name = 'Delete Properties'

    def run(self, chain, number, rule, settings, context, *args, **kwargs):
        changed = False
        name = settings['name']
        props = self.get_props(name, rule.style)
        for prop in props:
            rule.style.removeProperty(prop.name)
            changed = True

        # delete rule if style has no properties
        self.delete_rule_if_empty(rule)
        return changed

    def validate(self, settings):
        if not settings:
            return (_('Settings Error'), _('You must configure this filter'))
        if not settings.get('name'):
            return (_('Settings Error'), _('You must specify an property name'))
        return True

    def config_widget(self):
        return ActionWidget
