#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2020, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from collections import OrderedDict

from calibre import prints
from calibre.constants import DEBUG
from calibre.gui2 import error_dialog

from calibre_plugins.editor_chains.actions.style_actions.actions.base import StyleAction
from calibre_plugins.editor_chains.actions.style_actions.actions.delete_prop import DeletePropertiesAction
from calibre_plugins.editor_chains.actions.style_actions.actions.convert import ConvertUnitAction
from calibre_plugins.editor_chains.actions.style_actions.actions.style_arithmetic import ArithmeticAction
from calibre_plugins.editor_chains.actions.style_actions.actions.add_props import AddPropertiesAction
from calibre_plugins.editor_chains.actions.style_actions.actions.code import CodeAction

try:
    load_translations()
except NameError:
    prints("EditorChains::actions/style_actions/actions/__int__.py - exception when loading translations")



def get_user_style_actions(plugin_action):
    user_style_actions = {}
    for cls in plugin_action.user_modules.get_classes(class_filters=[StyleAction]):
        name = cls.name
        # must define a name attribute, must be set and not clash with builtin names
        # which can be imported into the module manager by custom actions
        if name in ['', 'StyleAction']:
            continue
        user_style_actions[name] = cls
    return user_style_actions

def get_all_style_actions(plugin_action):

    builtin_style_actions = OrderedDict()
    
    _builtin_style_actions = [
        DeletePropertiesAction,
        ConvertUnitAction,
        ArithmeticAction,
        AddPropertiesAction,
        CodeAction
    ]

    for style_action_cls in _builtin_style_actions:
        builtin_style_actions[style_action_cls.name] = style_action_cls

    _user_style_actions = get_user_style_actions(plugin_action)

    all_style_actions = OrderedDict()
    user_style_actions = OrderedDict()
    
    for style_action_name, style_action_cls in builtin_style_actions.items():
        if style_action_name in ['', 'Element Action']:
            continue
        style_action = style_action_cls(plugin_action)
        all_style_actions[style_action_name] = style_action

    for style_action_name, style_action_cls in _user_style_actions.items():
        # dont override builtin style_actions
        if style_action_name in list(builtin_style_actions.keys()) + ['', 'Element Action']:
            continue
        try:
            style_action = style_action_cls(plugin_action)
            all_style_actions[style_action_name] = style_action
            user_style_actions[style_action_name] = style_action
        except Exception as e:
            import traceback
            if DEBUG:
                prints(f'Editor Chains: Style Actions: Error intializing user filter: {style_action_name}\n{traceback.format_exc()}')

    return all_style_actions, builtin_style_actions, user_style_actions
