#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2022, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from calibre import prints
from calibre.constants import DEBUG
from calibre.ebooks.oeb.base import OEB_DOCS, XPNSMAP, XLINK
from polyglot.urllib import unquote as urlunquote

from calibre_plugins.editor_chains.actions.base import EditorAction

try:
    load_translations()
except NameError:
    prints("EditorChains::actions/remove_unused_images.py - exception when loading translations")

class RemoveUnusedImages(EditorAction):

    name = 'Remove Unused Images'
    _is_builtin_ = True
    headless = True

    def run(self, chain, settings, *args, **kwargs):
        all_images = set()
        referenced_images = set()
        container = chain.current_container
        for name, media_type in container.mime_map.items():
            if media_type.lower().startswith('image/'):
                all_images.add(name)
            elif media_type in OEB_DOCS:
                root = container.parsed(name)
                hrefs = root.xpath('//h:img/@src', namespaces=XPNSMAP) + root.xpath('//svg:svg/svg:image/@xl:href', namespaces=XPNSMAP)
                for href in hrefs:
                    img = container.href_to_name(href, name)
                    referenced_images.add(img)
        delete = all_images.difference(referenced_images)
        for img in delete:
            if DEBUG:
                prints(f'Editor Chains: Removing unused image: {img}')
            container.remove_item(img)

    def validate(self, settings):
        return True

