#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2022, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from qt.core import QApplication

from calibre import prints
from calibre.constants import DEBUG
from calibre.ebooks.oeb.polish.pretty import pretty_all

from calibre_plugins.editor_chains.actions.base import EditorAction

try:
    load_translations()
except NameError:
    prints("EditorChains::actions/pretty_all.py - exception when loading translations")

class BeautifyAll(EditorAction):

    name = 'Beautify All'
    _is_builtin_ = True
    headless = True

    def run(self, chain, settings, *args, **kwargs):
        pretty_all(chain.current_container)
        if chain.gui:
            chain.boss.update_editors_from_container()
            chain.boss.set_modified()
            if chain.gui:
                QApplication.alert(chain.gui)

    def validate(self, settings):
        return True

