#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__ = 'GPL v3'
__copyright__ = '2022, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

from qt.core import (QApplication, Qt, QWidget, QVBoxLayout,
                     QCheckBox, QLabel)

from calibre import prints
from calibre.constants import DEBUG
from calibre.ebooks.oeb.polish.main import tweak_polish
from calibre.ebooks.oeb.polish.main import CUSTOMIZATION

from calibre_plugins.editor_chains.actions.base import EditorAction

try:
    load_translations()
except NameError:
    prints("EditorChains::actions/embed_fonts.py - exception when loading translations")

class EmbedFonts(EditorAction):

    name = 'Embed Fonts'
    _is_builtin_ = True
    headless = True

    def run(self, chain, settings, *args, **kwargs):
        action = 'embed'
        customization = CUSTOMIZATION.copy()
        if customization is None:
            return
        report, changed = tweak_polish(chain.current_container, {action:True}, customization=customization)

    def validate(self, settings):
        return True

