#!/usr/bin/env python
# ~*~ coding: utf-8 ~*~

__license__   = 'GPL v3'
__copyright__ = '2020, Ahmed Zaki <azaki00.dev@gmail.com>'
__docformat__ = 'restructuredtext en'

PLUGIN_DESCRIPTION = "Automate various tasks in Calibre's ebook editor. Plugin allows to chain multiple actions together. You can choose from Plugin specific actions, calibre builtin actions, or create you own actions through the plugin's module editor."

from calibre.customize import EditBookToolPlugin

class EditorChainsPlugin(EditBookToolPlugin):

    name = 'Editor Chains'
    version = (1, 1, 8)
    author = 'Ahmed Zaki'
    supported_platforms = ['windows', 'osx', 'linux']
    description = PLUGIN_DESCRIPTION
    minimum_calibre_version = (5, 33, 0)


    def cli_main(self, args):
        import sys
        from qt.core import QApplication
        from calibre_plugins.editor_chains.headless import cmdline_run
        _app = QApplication([])
        args.remove("Editor Chains")
        cmdline_run(args)
