//compile: cl /MD lrs2lrf.cpp
#pragma comment(lib, "XylogParser.lib")
#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <io.h>

extern "C" {
  void __stdcall _MSXML_InitInstance();
  int  __stdcall _XYP_Create();
  int  __stdcall _XYP_GetVersion();
  void __stdcall _XYP_SetOutputFD(int fd);
  void __stdcall _XYP_SetTextCompressionFlag(int flag);
  void __stdcall _XYP_SetLrfFileName(wchar_t* filename);
  void __stdcall _XYP_SetProducerName(wchar_t* filename);
  void __stdcall _XYP_SetScrambleNumber(int scramble);
  void __stdcall _XYP_SetAnchorFileName(wchar_t* filename1, wchar_t* filename2);
  void __stdcall _XYP_ParseDocument(wchar_t* filename);
  void __stdcall _XYP_Release();
  void __stdcall _MSXML_Release();
}

int wmain(int argc, wchar_t* argv[])
{
  if (argc<3)
  {
    wprintf(L"lrs2lrf 0.1 (c) 2005 roxfan\n");
    wprintf(L"Usage: lrs2lrf file.lrs file.lrf\n");
    return 1;
  }
  _MSXML_InitInstance();
  _XYP_Create();
  int log = _wopen(L"lrs2lrf.log",_O_BINARY | _O_WRONLY | _O_CREAT | _O_TRUNC, _S_IREAD | _S_IWRITE);
  int bom = 0xFEFF;
  _write(log, &bom, 2);
  int ver = _XYP_GetVersion();
  wprintf(L"XYP version: %d.%d\n",ver/1000,ver%1000);
  _XYP_SetOutputFD(log);
  _XYP_SetLrfFileName(argv[2]);
  _XYP_SetTextCompressionFlag(1);
  _XYP_SetScrambleNumber(0xFE00);
  //_XYP_SetAnchorFileName(L"lrs2lrf.lat",L"lrs2lrf.lap");
  _XYP_SetProducerName(L"lrs2lrf 0.1");
  _XYP_ParseDocument(argv[1]);
  _XYP_Release();
  _MSXML_Release();
  wprintf(L"End.\n");
  return 0;
}
