#include "inkview.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

void getShellOutput(char * command, char* res, size_t n){
	int pipefd[2];
	int l;
	pipe(pipefd);
	if(fork()){
		l=read(pipefd[0], res, n);
		if(l>=0)res[l]=0;
		close(pipefd[0]);
		close(pipefd[1]);
	} else {
		close(1);
		dup2(pipefd[1],1);
		execlp("sh", "sh", "-c", command, NULL);
	}
}

void getIP (char * res, size_t n) {
    getShellOutput( 
      "/sbin/ifconfig | grep addr: | grep Mask: | grep -v -F '127.0.0.1' | sed -e 's/.*inet addr://; s/ .*//'", 
      res, n);
}

char path[PATH_MAX];
ifont* defaultFont;

int main_handler(int type, int par1, int par2){
  int l;
  char cmd[PATH_MAX];
  char ip[100];
  int sw, sh;
  
  switch (type) {
    case EVT_INIT:
      defaultFont = OpenFont("LiberationMono", 32, 0);

      fprintf(stderr, "Starting\n");   
      
      NetConnect(NULL);
      getIP(ip,80);
      strcpy(ip+strlen(ip)-1, ":2121");

      fprintf(stderr, "IP: %s\n", ip);   
 
      sw = StringWidth(ip);
      sh = TextRectHeight(sw, ip, 0);
      FillArea(20, 20, sw, sh, WHITE);
      SetFont(defaultFont, BLACK);
      DrawString (20, 20, ip);

      fprintf(stderr, "IP drawn\n");   

      fprintf(stderr, "Our path: %s\n", path);

      strcpy(cmd, path);
      l=strlen(cmd);
      while (cmd[l] != '/') {
	      l--;
      }
      l++;
      strcpy(cmd+l, "vsftpd ");
      
      fprintf(stderr, "vsftpd: %s\n", cmd);

      l=strlen(cmd);
      strncpy(cmd+l, cmd, l);
      cmd[l+l]=0;

      l=strlen(cmd);
      strcpy(cmd+l-1, ".conf &");
    
      fprintf(stderr, "Command prepared\n");   
     
      fprintf(stderr, "Command: %s\n", cmd);   
  
      system(cmd);

      FullUpdate();
  
      break; 
    case EVT_KEYPRESS:
      switch (par1) {
        case KEY_BACK:
          kill(0, SIGTERM);
          kill(0, SIGKILL);
          CloseApp();
          break;
      }
      break;
    case EVT_EXIT:
      break;
  }
  return 0;
}

int main(int argc, char **argv) {
  strncpy(path, argv[0], PATH_MAX-1);
  path[PATH_MAX-1]=0;
  InkViewMain(main_handler);
  return 0;
}
