#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab
import sys, os, re, shutil, platform, tempfile, imghdr

from PIL import Image
from PIL.ExifTags import TAGS
from xml.sax.saxutils import escape

# main routine
def run(bk):
    ''' the main routine '''

    # get ebook root folder
    ebook_root = bk._w.ebook_root

    # get os temp folder
    temp_dir = tempfile.gettempdir()

    # get jpeg_files
    jpeg_manifest_items = []
    for manifest_id, href, mime in bk.manifest_iter():
        if mime == "image/jpeg":
            jpeg_manifest_items.append((manifest_id, href, mime))

    if jpeg_manifest_items == []:
        print('No jpeg files found.\nClick OK to close the Plugin Runner window.')
        return 0



    # process all manifested jpeg files in the Images folder
    bytes_saved = 0
    for manifest_id, href, mime in jpeg_manifest_items:
        jpeg_file_name = os.path.basename(href)
        img_bookpath = bk.id_to_bookpath(manifest_id)
        processed_file_path = os.path.join(temp_dir, jpeg_file_name)

        original_jpeg_path = os.path.abspath(os.path.join(ebook_root, bk.id_to_bookpath(manifest_id)))

        # double-check the file header to make sure it's really a jpeg file
        image_header = imghdr.what(original_jpeg_path)
        if image_header != 'jpeg':
            print(jpeg_file_name, 'is a {} file!\n'.format(image_header))
            continue

        img = Image.open(os.path.join(ebook_root, bk.id_to_bookpath(manifest_id)))

        try:
            img_exif = img.getexif()

            orientation_key = [key for key, value in TAGS.items() if value == 'Orientation']
            if orientation_key:
                orientation = 0
                try:
                    orientation = img_exif[orientation_key[0]]
                except Exception:
                    pass

                if orientation > 1:
                    bk.add_extended_result("error", escape(img_bookpath), None, None, f"Image orientation is different from 1, value: {orientation}")
        except (AttributeError, KeyError, IndexError):
            pass

    print('\nDone.\nClick OK to close this window.')

    return 0

def main():
    print('I reached main when I should not have\n')
    return -1

if __name__ == "__main__":
    sys.exit(main())
