#include <stdlib.h>
#include <string.h>
#include "mupdf/fitz.h"
#include "draw.h"
#include "doc.h"

#define MIN_(a, b)	((a) < (b) ? (a) : (b))

static float layout_w = FZ_DEFAULT_LAYOUT_W;
static float layout_h = FZ_DEFAULT_LAYOUT_H;
static float layout_em = FZ_DEFAULT_LAYOUT_EM;
static char *layout_css = NULL;
static int layout_use_doc_css = 1;

struct doc {
	fz_context *ctx;
	fz_document *pdf;
};

void *doc_draw(struct doc *doc, int p, int zoom, int rotate, int *rows, int *cols)
{
	fz_matrix ctm;
	fz_pixmap *pix;
	fbval_t *pbuf;
	int x, y;
	ctm = fz_scale((float) zoom / 100, (float) zoom / 100);
	ctm = fz_pre_rotate(ctm, rotate);
	pix = fz_new_pixmap_from_page_number(doc->ctx, doc->pdf,
			p - 1, ctm, fz_device_rgb(doc->ctx), 0);
	if (!pix)
		return NULL;
	if (!(pbuf = malloc(pix->w * pix->h * sizeof(pbuf[0])))) {
		fz_drop_pixmap(doc->ctx, pix);
		return NULL;
	}
	for (y = 0; y < pix->h; y++) {
		unsigned char *s = &pix->samples[y * pix->stride];
		for (x = 0; x < pix->w; x++)
			pbuf[y * pix->w + x] = FB_VAL(s[x * pix->n + 0],
					s[x * pix->n + 1], s[x * pix->n + 2]);
	}
	fz_drop_pixmap(doc->ctx, pix);
	*cols = pix->w;
	*rows = pix->h;
	return pbuf;
}

int doc_pages(struct doc *doc)
{
	return fz_count_pages(doc->ctx, doc->pdf);
}

struct doc *doc_open(char *path)
{
	struct doc *doc = malloc(sizeof(*doc));
	doc->ctx = fz_new_context(NULL, NULL, FZ_STORE_DEFAULT);
	fz_register_document_handlers(doc->ctx);
	fz_try (doc->ctx) {
		doc->pdf = fz_open_document(doc->ctx, path);
	} fz_catch (doc->ctx) {
		fz_drop_context(doc->ctx);
		free(doc);
		return NULL;
	}
	if (getenv("FBPDF_CSS") != NULL) {
		printf("FBPDF_CSS = %s\n", getenv("FBPDF_CSS"));
		layout_css = getenv("FBPDF_CSS");
		if (getenv("FBPDF_DOCCSS") != NULL) {
			printf("FBPDF_DOCCSS = %s\n", getenv("FBPDF_DOCCSS"));
			layout_use_doc_css = fz_atoi(getenv("FBPDF_DOCCSS"));
			if (layout_use_doc_css != 0)
				layout_use_doc_css = 1;
		}
		fz_buffer *buf = fz_read_file(doc->ctx, layout_css);
		fz_set_user_css(doc->ctx, fz_string_from_buffer(doc->ctx, buf));
		fz_drop_buffer(doc->ctx, buf);
		fz_set_use_document_css(doc->ctx, layout_use_doc_css);
	}
	if (getenv("FBPDF_WIDTH") != NULL) {
		printf("FBPDF_WIDTH = %s\n", getenv("FBPDF_WIDTH"));
		layout_w = fz_atof(getenv("FBPDF_WIDTH"));
		if (layout_w < 50 || layout_w > 5000) {
			layout_w = FZ_DEFAULT_LAYOUT_W;
		}
	} else {
		layout_w = FZ_DEFAULT_LAYOUT_W;
	}
	fz_layout_document(doc->ctx, doc->pdf, layout_w, layout_h, layout_em);
	return doc;
}

void doc_close(struct doc *doc)
{
	fz_drop_document(doc->ctx, doc->pdf);
	fz_drop_context(doc->ctx);
	free(doc);
}
