#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fts.h>
#include <dlfcn.h>
#include <inkview.h>

/*
 * Valid answers are printed to stdout and the return code is 0.
 * Invalid answers are suppressed and the return code is non-zero.
 */

int ret = 0;
enum action_types { SHOW_MESSAGE, GET_NUMBER, GET_TEXT, QUERY, UNSUPPORTED };
enum traverse_types { RECURSIVE, FLAT };
static int action = UNSUPPORTED;
static char *prog = NULL;
static char *msg = NULL;
tocentry *toc = NULL;
#define bufsize 1024
static char buf[bufsize];
static int fd = 1;

void output(const char *fmt, ...) {
	/* This kludge is for getting around the emulator swallowing output
	 * to stdout. */
	char obuf[bufsize];
	va_list args;
	va_start(args, fmt);
	vsnprintf(obuf, bufsize, fmt, args);
	write(fd, obuf, strlen(obuf));
	va_end(args);
}

void set_active_task(void) {
	/* The latest PocketBook systems require that this task be set Active
	 * for the dialog to be shown.  We do that with the GetCurrentTask()
	 * and SetActiveTask() functions.  Not all versions of the InkView API
	 * have these functions, so we'll dynamically search for them at
	 * runtime rather than try to link to them directly. */
	void *handle;
	int (*gct)(void);
	int (*sat)(int, int);

	if ((handle = dlopen("libinkview.so", RTLD_LAZY))) {
		*(void **) (&gct) = dlsym(handle, "GetCurrentTask");
		*(void **) (&sat) = dlsym(handle, "SetActiveTask");
		if (gct && sat) {
			/* execute SetActiveTask(GetCurrentTask(), 0) */
			int task = (*gct)();
			(*sat)(task, 0);
		}
		dlclose(handle);
	}
}

void char_handler(char *s) {
	if (s && *s)
		output("%s\n", s);
	else
		ret = -1;
	CloseApp();
}

void query_handler(int button) {
	if (button == 1 || button == 2)
		output("%s\n", button == 1 ? 'y' : 'n');
	else
		ret = -1;
	CloseApp();
}


void dlg_handler(int button) {
	CloseApp();
}


int main_handler(int type, int par1, int par2) {
        SetPanelType(0);
	if (type == EVT_INIT) {
		set_active_task();
		switch (action) {
			case GET_NUMBER:
				buf[0] = '\0';
				OpenKeyboard(msg, buf, bufsize, KBD_NUMERIC, char_handler);
				break;
			case GET_TEXT:
				buf[0] = '\0';
				OpenKeyboard(msg, buf, bufsize, KBD_NORMAL, char_handler);
				break;
			case QUERY:
				Dialog(ICON_QUESTION, prog, msg, GetLangText("@Yes"), GetLangText("@No"), query_handler);
				break;
			case SHOW_MESSAGE:
				Message(ICON_INFORMATION, prog, msg, 5000);
				CloseApp();
				ClearScreen();
				FullUpdate();
				break;
			case UNSUPPORTED:
			default:
				Dialog(ICON_INFORMATION, prog, msg, GetLangText("@Close"), NULL, dlg_handler);
				break;
		}
	}

	//Use any key press outside the UI boxes to leave.
	if (type == EVT_KEYRELEASE || type == EVT_KEYREPEAT) {
		ret = -1;
		CloseApp();
	}

	if (type == EVT_EXIT) {
		close(fd);
	}

	return 0;
}

int main(int argc, char **argv) {
	msg = "Usage:  sh_ivtool -? \"message\"\n  -s \"message\"   Self closing message\n  -n \"message\"   Get number input\n  -t \"message\"   Get text input\n  -q \"message\"   yes/no question\n  -h  Show this message.\n";

	prog = argv[0];
	if (argc == 3 && !strcmp(argv[1], "-s")) {
		action = SHOW_MESSAGE;
		msg = argv[2];
	} else if (argc == 3 && !strcmp(argv[1], "-n")) {
		action = GET_NUMBER;
		msg = argv[2];
	} else if (argc == 3 && !strcmp(argv[1], "-t")) {
		action = GET_TEXT;
		msg = argv[2];
	} else if (argc == 3 && !strcmp(argv[1], "-q")) {
		action = QUERY;
		msg = argv[2];
	} else
		ret = -1;
        
	/* dup stdout to bypass the emulator swallowing output */
	fd = dup(1);
	close(1);

	InkViewMain(main_handler);
	return ret;
}
