#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#


import os, os.path, sys, codecs, shutil, inspect
from tempfile import mkdtemp                  
from cutils2 import *
from cutils3 import addSectionTitleText
from cutils import  show_msgbox, prettifyCode
from updater import updateCheck
from dialogs1 import AppDialog1
from dialogs2 import AppDialog2
import options
import time
import tkinter as tk

try:
    from sigil_bs4 import BeautifulSoup, Comment
except:
    from bs4 import BeautifulSoup, Comment  

SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=3547774&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
options.PLUGIN_PATH = PLUGIN_PATH

prefs = {}

def is_connected():
    try:
        sock = socket.create_connection(('8.8.8.8', 53), 1)
        sock.close()
        return(True)
    except:
        pass

    return(False)        
    
def run(bk):
    print('Python version: ', sys.version, '\n')
    print('Running CustomCleanerPlus...\n')
    
    # only allow epub 2 or epub 3 with this plugin
    if len(list(bk.text_iter())) == 1:
        msg = "ERROR: This plugin requires either a valid epub 2 or valid epub 3 as input. Please try again"
        show_msgbox('Formatting Error:', msg, msgtype='error')
        return (-1)    
    
    # set flags for epub 2 or epub 3.     #### New Code
    if bk.epub_version() == '2.0':
        options.EPUB_VERSION = 'EPUB2'
    if bk.epub_version() == '3.0':
        options.EPUB_VERSION = 'EPUB3'
    
    if is_connected: 
        # check for new plugin versions
        latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
        if latest_version and latest_version != installed_version:
            options.NEW_PLUGIN_VERSION = True
            options.MSG_NEW_VERSION_AVAILABLE = "A new version of this plugin is now available from MR - v" + latest_version     
            
    global prefs
    # initialize prefs
    prefs = bk.getPrefs()
    if 'convert_tags' not in prefs:
        prefs['convert_tags'] = False
    if 'remove_fonts' not in prefs:
        prefs['remove_fonts'] = False
    if 'remove_empty_paras' not in prefs:
        prefs['remove_empty_paras'] = False    
    if 'remove_breaks' not in prefs:
        prefs['remove_breaks'] = False     
    if 'preserve_imgsize' not in prefs:
        prefs['preserve_imgsize'] = False
    if 'remove_default_text_color' not in prefs:
        prefs['remove_default_text_color'] = False    
    if 'remove_default_BG_color' not in prefs:
        prefs['remove_default_BG_color'] = False        
    if 'remove_nbsp_entities' not in prefs:
        prefs['remove_nbsp_entities'] = False   
    if 'remove_unused_images' not in prefs:
        prefs['remove_unused_images'] = False             
    if 'remove_hyphen_props' not in prefs:
        prefs['remove_hyphen_props'] = False       
    if 'remove_ids_and_links' not in prefs:
        prefs['remove_ids_and_links'] = False           
    if 'remove_inetlinks' not in prefs:
        prefs['remove_inetlinks'] = False           
    if 'remove_intlinks' not in prefs:
        prefs['remove_intlinks'] = False
    if 'replace_div_tags' not in prefs:
        prefs['replace_div_tags'] = False
    if 'remove_hr_tags' not in prefs:    
        prefs['remove_hr_tags'] = False      
    if 'remove_ids' not in prefs:
        prefs['remove_ids'] = False        
    if 'remove_divs' not in prefs:
        prefs['remove_divs'] = False
    if 'remove_page_links' not in prefs:
        prefs['remove_page_links'] = False    
    if 'remove_line_height' not in prefs:
        prefs['remove_line_height'] = False
    if 'remove_empty_spans' not in prefs:
        prefs['remove_empty_spans'] = False        
    bk.savePrefs(prefs)    
    
    # create a working directory
    WDIR = mkdtemp()
    
    # repair image file names in the Images dir
    repairImageFileNames(bk)
    
    # add heading names to all <title> tags per section
    addSectionTitleText(bk)
    
    # copy css files, images and xhtml files to the work dir
    t_ids, t_fnames = copyTextFiles2Dir(bk, WDIR)           # copy epub text files    
    i_ids, i_fnames = copyImageFiles2Dir(bk, WDIR)          # copy epub images
    s_ids, s_fnames = copyCSSFiles2Dir(bk, WDIR)            # copy epub css file
    
    if t_fnames[0] == 'Section0001.xhtml' and len(t_fnames) == 1:
        msg = 'WARNING: You haven\'t loaded an epub file. You cannot run this plugin on Sigil\'s new file stub. Please load a valid epub 2 or epub 3 file before you run this plugin.'
        show_msgbox('New File Stub Warning!', msg, 'warning')
        cleanExit(WDIR)
        return(0)
   
    win_dialog1 = AppDialog1(bk)
    win_dialog1.mainloop()
    
    # if dialog 'Cancel' or exit 
    # is pressed then exit run()
    if options.SYS_EXIT == True:
       cleanExit(WDIR)
       return(0)        
    
    win_dialog2 = AppDialog2(bk)
    win_dialog2.mainloop()
    
    # if dialog 'Cancel' or exit 
    # is pressed then exit run()
    if options.SYS_EXIT == True:
       cleanExit(WDIR)
       return(0)        
       
    # process both the automatic tasks and user selected tasks
    processAllTasks(bk, WDIR, t_fnames, s_fnames, s_ids)
    #s_fnames = css_fnames
    
     # For Cancel or exit -- exit run()
    if options.SYS_EXIT == True:
       cleanExit(WDIR)
       return(-1)
       
    # write the modified files back to the epub
    writeFiles2Epub(bk, WDIR, t_ids, t_fnames)
    writeFiles2CSS(bk, WDIR, s_ids, s_fnames)
   
    # save selections for next session
    bk.savePrefs(prefs)  
   
    # inform user if new plugin version is available
    if options.NEW_PLUGIN_VERSION == True:
        msg = options.MSG_NEW_VERSION_AVAILABLE
        show_msgbox('CustomCleanerPlus', msg, msgtype='info') 
    
    print('\n -- Completed SUCCESSFULLY...')
    cleanExit(WDIR)
    return(0)                
    
def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())                         
    
    