#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys
import time
import options
            
from cutils import show_msgbox   ###         
import tkinter
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 

LINUX_MACHINE = False
if sys.platform == 'linux' or \
    sys.platform == 'darwin':
    LINUX_MACHINE = True

def populate(self):
    gui_prefs = self.bk.getPrefs()
    
    # used in AppDialog2
    self.idslinks.set(gui_prefs['remove_ids_and_links'])
    self.repdiv.set(gui_prefs['replace_div_tags'])
    self.inetlinks.set(gui_prefs['remove_inetlinks'])
    self.intlinks.set(gui_prefs['remove_intlinks'])
    self.rmhrtags.set(gui_prefs['remove_hr_tags'])    
    self.ids.set(gui_prefs['remove_ids'])
    self.div.set(gui_prefs['remove_divs'])
    self.rmpagelinks.set(gui_prefs['remove_page_links'])        
    self.rmLH.set(gui_prefs['remove_line_height'])
    self.rmempty.set(gui_prefs['remove_empty_spans'])    
    
    options.REMOVE_IDS_AND_LINKS = gui_prefs['remove_ids_and_links']
    options.REPLACE_DIV_TAGS = gui_prefs['replace_div_tags']
    options.REMOVE_INET_LINKS = gui_prefs['remove_inetlinks']
    options.REMOVE_INT_LINKS = gui_prefs['remove_intlinks']
    options.REMOVE_HR_TAGS = gui_prefs['remove_hr_tags'] 
    options.REMOVE_IDS = gui_prefs['remove_ids']
    options.REMOVE_DIV_TAGS = gui_prefs['remove_divs']  
    options.REMOVE_DIV_TAGS = gui_prefs['remove_page_links']     
    options.REMOVE_LH = gui_prefs['remove_line_height']
    options.REMOVE_EMPTY_SPANS = gui_prefs['remove_empty_spans']    
    
    return(0)        

def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 25)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
        
class AppDialog2(Tk):

    def __init__(self, bk):
        super().__init__()
        self.bk = bk
        self.resizable(width=True, height=True)
        self.minsize(350, 300)
        self.maxsize(800, 900)
        self.title('User Options 2')   
        centeredWindow(self, 440, 460)   #440
        self.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
        
    def setup_UI(self):
    
        self.labelf1 = Frame(self)
        self.labelf1.pack(side=TOP, fill=BOTH, expand=True)        
       
        self.InfoLabel = Label(self.labelf1, text="            ",
                        fg     = '#0000FF',
                        font    =('Helvetica', '11'),                         
                        anchor = E
                        )
        self.InfoLabel.grid(column=1,sticky=E, row=0, padx=43, pady=0)       
        
        btnSelectAll = Button(self.labelf1, 
                        text    = "Select All",
                        bg      = '#EFEFEF',
                        font    =('Helvetica', '11'),                        
                        width   = 7, 
                        relief  = GROOVE,
                        command = self.onSelectAll 
                        ).grid(row=1, column=1,sticky=W, padx=50, pady=15) 
                        
        btnClearAll = Button(self.labelf1, 
                        text    = "Clear All",
                        bg      = '#EFEFEF',
                        font    =('Helvetica', '11'),                        
                        width   = 7, 
                        relief  = GROOVE,                          
                        command = self.onClearAll
                        )
        btnClearAll.grid(row=1, column=1,sticky=W, padx=135, pady=15)       

        self.saveselection = BooleanVar()
        chkbSaveSelection = Checkbutton(self.labelf1, 
                        text     = '  Save selections',
                        font     =('Helvetica', '11'),                   
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.saveselection,
                        command = self.onSaveSelection               
                        )
        chkbSaveSelection.grid(column=1, sticky=E, row=1, padx=0, pady=15)                 

        self.idslinks = BooleanVar() 
        chkbIDLinks = Checkbutton(self.labelf1, 
                        text     = '  Remove all ids and associated links.',
                        font     =('Helvetica', '11'),                          
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.idslinks,
                        command  = self.onIDsLinks             
                        )
        chkbIDLinks.grid(column=1, sticky=W, row=2, padx=50, pady=1)                  
        
        self.repdiv = BooleanVar() 
        chkbReplaceDiv = Checkbutton(self.labelf1, 
                        text     = '  Replace <div> tags with <p> tags.',
                        font     =('Helvetica', '11'),                
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.repdiv,
                        command  = self.onReplaceDIV               
                        )
        chkbReplaceDiv.grid(column=1, sticky=W, row=3, padx=50, pady=1)    
        
        self.inetlinks = BooleanVar() 
        chkbInetLinks = Checkbutton(self.labelf1, 
                        text     = '  Remove internet link formatting.',
                        font     =('Helvetica', '11'),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.inetlinks,
                        command  = self.onInetLinks               
                        )
        chkbInetLinks.grid(column=1, sticky=W, row=4, padx=50, pady=1)     
        
        self.intlinks = BooleanVar() 
        chkbIntLinks = Checkbutton(self.labelf1, 
                        text     = '  Remove internal link formatting.',
                        font     =('Helvetica', '11'),                
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.intlinks,
                        command  = self.onIntLinks               
                        )
        chkbIntLinks.grid(column=1, sticky=W, row=5, padx=50, pady=1)   

        self.rmLH = BooleanVar() 
        chkbRMLineHeight = Checkbutton(self.labelf1, 
                        text     = '  Remove line-height from CSS.',   
                        font     =('Helvetica', '11'),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.rmLH,
                        command  = self.onRMLineHeight               
                        )
        chkbRMLineHeight.grid(column=1, sticky=W, row=6, padx=50, pady=1)        
        
        self.rmhrtags = BooleanVar() 
        chkbRMHR = Checkbutton(self.labelf1, 
                        text     = '  Remove horizontal rule tags.',
                        font     =('Helvetica', '11'),                
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.rmhrtags,
                        command  = self.onRMHR               
                        )
        chkbRMHR.grid(column=1, sticky=W, row=7, padx=50, pady=1)            
        
        self.ids = BooleanVar() 
        chkbIDs = Checkbutton(self.labelf1, 
                        text     = '  Remove all ids/bookmarks.',
                        font     =('Helvetica', '11'),                          
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.ids,
                        command  = self.onIDS             
                        )
        chkbIDs.grid(column=1, sticky=W, row=8, padx=50, pady=1)                         
        
        self.div = BooleanVar() 
        chkbDiv = Checkbutton(self.labelf1, 
                        text     = '  Remove all <div> tags.',
                        font     =('Helvetica', '11'),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.div,
                        command  = self.onDiv               
                        )
        chkbDiv.grid(column=1, sticky=W, row=9, padx=50, pady=1)   
        
        self.rmpagelinks = BooleanVar() 
        chkbRMPageLinks = Checkbutton(self.labelf1, 
                        text     = '  Remove all page links.',   
                        font     =('Helvetica', '11'),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.rmpagelinks,
                        command  = self.onRMPageLinks               
                        )
        chkbRMPageLinks.grid(column=1, sticky=W, row=10, padx=50, pady=1)
        
        self.rmempty = BooleanVar() 
        chkbRMEmptySpans = Checkbutton(self.labelf1, 
                        text     = '  Remove empty spans.',   
                        font     =('Helvetica', '11'),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.rmempty,
                        command  = self.onRMEmptySpans               
                        )
        chkbRMEmptySpans.grid(column=1, sticky=W, row=11, padx=50, pady=1)        
        
        self.frame1 = Frame(self).pack(side=TOP)   
        
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', '11'), width=20, relief=GROOVE) 
        self.okButton = ttk.Button(self.frame1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        )
        self.okButton.pack(pady=20)     

        #**** Create the statusbar *****#
        self.status = Label(self, text=" ",
                        font   = ('Helvetica', '11'),
                        relief = FLAT,
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.pack(side=LEFT, pady=0, padx=5) 
        
        if LINUX_MACHINE == True:
            centeredWindow(self, 505, 460)
            self.InfoLabel.grid(padx=40)
            btnClearAll.grid(padx=145)
            self.okButton.pack(pady=10)
        
        """          
        if options.EPUB_VERSION == 'EPUB2':
            self.InfoLabel.config(text="Input File: EPUB 2  ")      
        else:
            self.InfoLabel.config(text="Input File: EPUB 3  ")      
        """
        
        # populate chk boxes with saved 
        # selections from last session    
        populate(self)    
        self.grab_set()
      
    def onSaveSelection(self):
        if self.saveselection.get() == True:
            options.SAVE_SELECTIONS = True
        else:
            options.SAVE_SELECTIONS = False        
                      
      
    def onSelectAll(self):
        self.idslinks.set(True)
        options.REMOVE_IDS_AND_LINKS = True
        self.repdiv.set(True)
        options.REPLACE_DIV_TAGS = True
        self.inetlinks.set(True)
        options.REMOVE_INET_LINKS = True
        self.intlinks.set(True)
        options.REMOVE_INT_LINKS = True
        self.rmLH.set(True)
        options.REMOVE_LH = True        
        self.rmhrtags.set(True)
        options.REMOVE_HR_TAGS = True        
        self.ids.set(True)
        options.REMOVE_IDS = True
        self.div.set(True)
        options.REMOVE_DIV_TAGS = True       
        self.rmpagelinks.set(True)
        options.REMOVE_PAGE_LINKS = True
        self.rmempty.set(True)
        options.REMOVE_EMPTY_SPANS = True       
        return(0)   
        
    def onClearAll(self):    
        self.idslinks.set(False)
        self.repdiv.set(False)
        self.inetlinks.set(False) 
        self.intlinks.set(False)
        self.rmLH.set(False)
        self.rmhrtags.set(False)
        self.ids.set(False)
        self.div.set(False)
        self.rmpagelinks.set(False)
        self.rmempty.set(False)
        
        options.REMOVE_IDS_AND_LINKS = False
        options.REPLACE_DIV_TAGS = False
        options.REMOVE_INET_LINKS = False
        options.REMOVE_INT_LINKS = False
        options.REMOVE_LH = False
        options.REMOVE_HR_TAGS = False        
        options.REMOVE_IDS = False
        options.REMOVE_PAGE_LINKS = False
        options.REMOVE_DIV_TAGS = False
        options.REMOVE_EMPTY_SPANS = False
        return(0)    
       
    def onIDsLinks(self):
        if self.idslinks.get() == True:
            options.REMOVE_IDS_AND_LINKS = True             
        else:
            options.REMOVE_IDS_AND_LINKS = False                        
            
    def onReplaceDIV(self):
        if self.repdiv.get() == True:
            options.REPLACE_DIV_TAGS = True       
        else:
            options.REPLACE_DIV_TAGS = False             
            
    def onInetLinks(self):
        if self.inetlinks.get() == True:
            options.REMOVE_INET_LINKS = True       
        else:
            options.REMOVE_INET_LINKS = False                 
            
    def onIntLinks(self):
        if self.intlinks.get() == True:
            options.REMOVE_INT_LINKS = True     
        else:
            options.REMOVE_INT_LINKS = False
            
    def onRMLineHeight(self):
        if self.rmLH.get() == True:
            options.REMOVE_LH = True       
        else:
            options.REMOVE_LH = False        
            
    def onRMHR(self):
        if self.rmhrtags.get() == True:
            options.REMOVE_HR_TAGS = True     
        else:
            options.REMOVE_HR_TAGS = False            
        
    def onIDS(self):
        if self.ids.get() == True:
            options.REMOVE_IDS = True     
        else:
            options.REMOVE_IDS = False             
            
    def onDiv(self):   
        if self.div.get() == True:
            options.REMOVE_DIV_TAGS  = True       
        else:
            options.REMOVE_DIV_TAGS  = False             
            
    def onRMPageLinks(self):   
        if self.rmpagelinks.get() == True:
            options.REMOVE_PAGE_LINKS  = True       
        else:
            options.REMOVE_PAGE_LINKS  = False 

    def onRMEmptySpans(self):
        if self.rmempty.get() == True:
            options.REMOVE_EMPTY_SPANS = True       
        else:
            options.REMOVE_EMPTY_SPANS = False    
            
    def onOK(self):
        gui_prefs = self.bk.getPrefs()
         
        # save user selections
        if self.saveselection.get() == True:
            
            gui_prefs['remove_ids_and_links'] = self.idslinks.get()
            if self.idslinks.get() == True:
                options.REMOVE_IDS_AND_LINKS = True
            else:
                options.REMOVE_IDS_AND_LINKS = False                  

            gui_prefs['replace_div_tags'] = self.repdiv.get()
            if self.repdiv.get() == True:
                options.REPLACE_DIV_TAGS = True
            else:
                options.REPLACE_DIV_TAGS = False                                  
            
            gui_prefs['remove_inetlinks'] = self.inetlinks.get()
            if self.inetlinks.get() == True:
                options.REMOVE_INET_LINKS = True
            else:
                options.REMOVE_INET_LINKS = False            
                
            gui_prefs['remove_intlinks'] = self.intlinks.get()
            if self.intlinks.get() == True:
                options.REMOVE_INT_LINKS = True
            else:
                options.REMOVE_INT_LINKS = False    
                
            gui_prefs['remove_line_height'] = self.rmLH.get()
            if self.rmLH.get() == True:
                options.REMOVE_LH = True
            else:
                options.REMOVE_LH = False                   

            gui_prefs['remove_hr_tags'] = self.rmhrtags.get()
            if self.rmhrtags.get() == True:
                options.REMOVE_HR_TAGS = True  
            else:
                options.REMOVE_HR_TAGS = False  
            
            gui_prefs['remove_ids'] = self.ids.get()
            if self.ids.get() == True:
                options.REMOVE_IDS = True
            else:
                options.REMOVE_IDS = False                        
            
            gui_prefs['remove_divs'] = self.div.get()
            if self.div.get() == True:
                options.REMOVE_DIV_TAGS = True
            else:
                options.REMOVE_DIV_TAGS = False          
            
            gui_prefs['remove_page_links'] = self.rmpagelinks.get()
            if self.rmpagelinks.get() == True:
                options.REMOVE_PAGE_LINKS = True
            else:
                options.REMOVE_PAGE_LINKS = False                    
 
            gui_prefs['remove_empty_spans'] = self.rmempty.get()
            if self.rmempty.get() == True:
                options.REMOVE_EMPTY_SPANS = True
            else:
                options.REMOVE_EMPTY_SPANS = False                               
            
            
            
            
        self.bk.savePrefs(gui_prefs)
        self.destroy() 
        self.quit()
     
    def onCancel(self):
        options.SYS_EXIT = True
        self.destroy()  
        return(0)
        
  

