#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys
import time
import options
            
from cutils import show_msgbox   ###         
import tkinter
from tkinter import *
import  tkinter.filedialog as fdbox
import tkinter.messagebox as mbox 
from tkinter import ttk 

LINUX_MACHINE = False
if sys.platform == 'linux' or \
    sys.platform == 'darwin':
    LINUX_MACHINE = True

def populate(self):
    gui_prefs = self.bk.getPrefs()
    
    # used in AppDialog1
    self.converttags.set(gui_prefs['convert_tags'])
    self.color.set(gui_prefs['remove_default_text_color']) 
    self.bgcolor.set(gui_prefs['remove_default_BG_color']) 
    self.imgsize.set(gui_prefs['preserve_imgsize'])
    self.rm_images.set(gui_prefs['remove_unused_images'])
    self.removebr.set(gui_prefs['remove_breaks'])
    self.remnbsp.set(gui_prefs['remove_nbsp_entities'])
    self.rmhyphen.set(gui_prefs['remove_hyphen_props'])
    self.fonts.set(gui_prefs['remove_fonts'])
    self.empty.set(gui_prefs['remove_empty_paras'])
    
    options.CONVERT_TAGS = gui_prefs['convert_tags']
    options.REMOVE_DEFAULT_TEXT_COLOR = gui_prefs['remove_default_text_color']
    options.REMOVE_DEFAULT_BG_COLOR = gui_prefs['remove_default_BG_color']    
    options.PRESERVE_IMG_SIZE = gui_prefs['preserve_imgsize']
    options.REMOVE_UNUSED_IMAGES = gui_prefs['remove_unused_images']
    options.REMOVE_HARD_BREAKS = gui_prefs['remove_breaks']
    options.REMOVE_NBSP_ENTITIES = gui_prefs['remove_nbsp_entities']
    options.REMOVE_HYPHEN_PROPS = gui_prefs['remove_hyphen_props']
    options.REMOVE_FONTS = gui_prefs['remove_fonts']
    options.REMOVE_EMPTY_PARAS = gui_prefs['remove_empty_paras']
    
    return(0)        

def centeredWindow(self, w, h):
    # get screen width and height
    ws = self.winfo_screenwidth()
    hs = self.winfo_screenheight()
   
    # calculate x and y coordinates for the Tk window
    x = (ws/2) - (w/2)
    y = ((hs/2) - (h/2) - 25)
    return(self.geometry('%dx%d+%d+%d' % (w, h, x, y)))
    
class AppDialog1(Tk):

    def __init__(self, bk):
        super().__init__()
        self.bk = bk
        self.resizable(width=True, height=True)
        self.minsize(350, 300)
        self.maxsize(800, 900)
        self.title('User Options 1')   
        centeredWindow(self, 585, 455) #585 470
        self.protocol("WM_DELETE_WINDOW", self.onCancel)
        self.setup_UI()
        
    def setup_UI(self):
    
        self.labelf1 = Frame(self)
        self.labelf1.pack(side=TOP, fill=BOTH, expand=True)        
        
        
        self.InfoLabel = Label(self.labelf1, text=" ",
                        fg     = '#0000FF',
                        font    =('Helvetica', '11'),                         
                        anchor = E
                        )
        self.InfoLabel.grid(column=1, sticky=E, row=0, padx=43, pady=0)       
        
        
        btnSelectAll = Button(self.labelf1, 
                        text    = "Select All",
                        bg      = '#EFEFEF',
                        font    =('Helvetica', '11'),                        
                        width   = 7, 
                        relief  = GROOVE,
                        command = self.onSelectAll 
                        ).grid(row=1, column=1,sticky=W, padx=50, pady=12) 
                        
        btnClearAll = Button(self.labelf1, 
                        text    = "Clear All",
                        bg      = '#EFEFEF',
                        font    =('Helvetica', '11'),                        
                        width   = 7, 
                        relief  = GROOVE,                          
                        command = self.onClearAll
                        )
        btnClearAll.grid(row=1, column=1,sticky=W, padx=135, pady=12)       

        self.saveselection = BooleanVar()
        chkbSaveSelection = Checkbutton(self.labelf1, 
                        text     = '  Save selections',
                        font     =('Helvetica', '11'),                   
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.saveselection,
                        command = self.onSaveSelection               
                        )
        chkbSaveSelection.grid(column=1, sticky=E, row=1, padx=50, pady=12)  ### 4               
       
        self.converttags = BooleanVar()
        chkbConvertTags = Checkbutton(self.labelf1, 
                        text     = '  Convert <i>, <b>, <em, <u>, <s> and <strong> tags to span styling.',
                        font     =('Helvetica', '11'),              
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.converttags,
                        command  = self.onConvertTags              
                        )
        chkbConvertTags.grid(column=1, sticky=W, row=2, padx=50, pady=1)    

        self.color = BooleanVar() 
        chkbColor = Checkbutton(self.labelf1, 
                        text     = '  Remove ad hoc black text color declarations from html and CSS.',
                        font     =('Helvetica', '11'),                   
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.color,
                        command = self.onColor                
                        )
        chkbColor.grid(column=1, sticky=W, row=3, padx=50, pady=1)           
        
        self.bgcolor = BooleanVar() 
        chkbBGColor = Checkbutton(self.labelf1, 
                        text     = '  Remove ad hoc white bg color declarations from html and CSS.',
                        font     =('Helvetica', '11'),                   
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.bgcolor,
                        command = self.onBGColor                
                        )
        chkbBGColor.grid(column=1, sticky=W, row=4, padx=50, pady=1)             
          
        self.imgsize = BooleanVar()
        chkbImgSize = Checkbutton(self.labelf1, 
                        text     = '  Reformat image sizes as a percentage of current screen size.',
                        font     =('Helvetica', '11'),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.imgsize,
                        command  = self.onImgSize               
                        )
        chkbImgSize.grid(column=1, sticky=W, row=5, padx=50, pady=1)            
                                   
        self.rm_images = BooleanVar() 
        chkbRemoveImages = Checkbutton(self.labelf1, 
                        text     = '  Remove any unused images from Sigil\'s \'Images\' directory.',
                        font     =('Helvetica', '11'),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.rm_images,
                        command  = self.onRemoveImages               
                        )
        chkbRemoveImages.grid(column=1, sticky=W, row=6, padx=50, pady=1)  

        self.removebr = BooleanVar()
        chkbRemoveBR = Checkbutton(self.labelf1, 
                        text     = '  Remove hard breaks(<br> tags) caused by the enter key.',
                        font     =('Helvetica', '11'),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.removebr,
                        command  = self.onRemoveBR               
                        )
        chkbRemoveBR.grid(column=1, sticky=W, row=7, padx=50, pady=1)               
        
        self.remnbsp = BooleanVar()
        chkbRemoveSpace = Checkbutton(self.labelf1, 
                        text     = "  Remove all non-breaking space entities from the html.",
                        font     =('Helvetica', '11'),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.remnbsp,
                        command  = self.onRemoveNBSpaces               
                        )
        chkbRemoveSpace.grid(column=1, sticky=W, row=8, padx=50, pady=1)          
        
        self.rmhyphen = BooleanVar()
        chkbrmhyphen = Checkbutton(self.labelf1, 
                        text     = '  Remove all hyphen class properties from the CSS.',
                        font     =('Helvetica', '11'),
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.rmhyphen,
                        command  = self.onrmHyphen               
                        )
        chkbrmhyphen.grid(column=1, sticky=W, row=9, padx=50, pady=1)        
        
        self.fonts = BooleanVar() 
        chkbFonts = Checkbutton(self.labelf1, 
                        text     = '  Remove all font-family declarations from the CSS.',
                        font     =('Helvetica', '11'),                   
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.fonts,
                        command = self.onFonts                
                        )
        chkbFonts.grid(column=1, sticky=W, row=10, padx=50, pady=1)
        
        self.empty = BooleanVar() 
        chkbEmpty = Checkbutton(self.labelf1, 
                        text     = '  Remove all empty paragraphs(with no text).',
                        font     =('Helvetica', '11'),                          
                        onvalue  = True,
                        offvalue = False, 
                        variable = self.empty,
                        command  = self.onEmpty             
                        )
        chkbEmpty.grid(column=1, sticky=W, row=11, padx=50, pady=1)                  
        
        self.frame1 = Frame(self).pack(side=TOP)   
        
        styler = ttk.Style()
        styler.configure('New.TButton', font=('Helvetica', '11'), width=20, relief=GROOVE) 
        self.okButton = ttk.Button(self.frame1, 
                        text    = "OK", 
                        style   = 'New.TButton', 
                        command = self.onOK
                        )
        self.okButton.pack(pady=25)     

        #**** Create the statusbar *****#
        self.status = Label(self, text=" ",
                        font   = ('Helvetica', '11'),
                        relief = FLAT,
                        fg     = '#0000FF',
                        anchor = W
                        )
        self.status.pack(side=LEFT, pady=0, padx=5) 
        
        if LINUX_MACHINE == True:
            centeredWindow(self, 650, 455)
            self.InfoLabel.grid(padx=40)
            btnClearAll.grid(padx=145)
            self.okButton.pack(pady=10)
        
        # populate chk boxes with saved 
        # selections from last session    
        populate(self)    
        self.grab_set()
      
    def onSaveSelection(self):
        if self.saveselection.get() == True:
            options.SAVE_SELECTIONS = True
        else:
            options.SAVE_SELECTIONS = False        
                      
      
    def onSelectAll(self):
        self.converttags.set(True)
        options.CONVERT_TAGS = True
        self.color.set(True)
        options.REMOVE_DEFAULT_TEXT_COLOR = True
        self.bgcolor.set(True)
        options.REMOVE_DEFAULT_BG_COLOR = True
        self.imgsize.set(True)
        options.PRESERVE_IMG_SIZE = True
        self.rm_images.set(True)
        options.REMOVE_UNUSED_IMAGES = True
        self.removebr.set(True)
        options.REMOVE_HARD_BREAKS = True
        self.remnbsp.set(True)
        options.REMOVE_NBSP_ENTITIES = True
        self.rmhyphen.set(True)
        options.REMOVE_HYPHEN_PROPS = True
        self.fonts.set(True)
        options.REMOVE_FONTS = True            
        self.empty.set(True)
        options.REMOVE_EMPTY_PARAS = True
        
        return(0)   
        
    def onClearAll(self):    
        self.converttags.set(False)
        self.color.set(False) 
        self.bgcolor.set(False) 
        self.imgsize.set(False) 
        self.rm_images.set(False)
        self.removebr.set(False)
        self.remnbsp.set(False)
        self.rmhyphen.set(False)
        self.fonts.set(False)
        self.empty.set(False)
       
        options.CONVERT_TAGS = False
        options.REMOVE_DEFAULT_TEXT_COLOR = False
        options.REMOVE_DEFAULT_BG_COLOR = False
        options.PRESERVE_IMG_SIZE = False
        options.REMOVE_UNUSED_IMAGES = False
        options.REMOVE_HARD_BREAKS  = False
        options.REMOVE_NBSP_ENTITIES = False
        options.REMOVE_HYPHEN_PROPS = False
        options.REMOVE_FONTS = False
        options.REMOVE_EMPTY_PARAS = False
       
    def onConvertTags(self):
        if self.converttags.get() == True:
            options.CONVERT_TAGS = True       
        else:
            options.CONVERT_TAGS = False                   
    
    def onColor(self):
        if self.color.get() == True:
            options.REMOVE_DEFAULT_TEXT_COLOR = True             
        else:
            options.REMOVE_DEFAULT_TEXT_COLOR = False         
            
    def onBGColor(self):
        if self.bgcolor.get() == True:
            options.REMOVE_DEFAULT_BG_COLOR = True             
        else:
            options.REMOVE_DEFAULT_BG_COLOR = False                 
    
    def onImgSize(self):
        if self.imgsize.get() == True:
            options.PRESERVE_IMG_SIZE = True             
        else:
            options.PRESERVE_IMG_SIZE = False 
            
    def onRemoveImages(self):
        if self.rm_images.get() == True:
            options.REMOVE_UNUSED_IMAGES = True             
        else:
            options.REMOVE_UNUSED_IMAGES = False                     
            
    def onRemoveBR(self):
        if self.removebr.get() == True:
            options.REMOVE_HARD_BREAKS = True             
        else:
            options.REMOVE_HARD_BREAKS = False    

    def onRemoveNBSpaces(self):
        if self.remnbsp.get() == True:
            options.REMOVE_NBSP_ENTITIES = True             
        else:
            options.REMOVE_NBSP_ENTITIES = False     
            
    def onrmHyphen(self):
        if self.rmhyphen.get() == True:
            options.REMOVE_HYPHEN_PROPS = True             
        else:
            options.REMOVE_HYPHEN_PROPS = False       

    def onFonts(self):
        if self.fonts.get() == True:
            options.REMOVE_FONTS = True
        else: 
            options.REMOVE_FONTS = False   
            
    def onEmpty(self):
        if self.empty.get() == True:
            options.REMOVE_EMPTY_PARAS = True
        else: 
            options.REMOVE_EMPTY_PARAS = False           
            
    def onOK(self):
        gui_prefs = self.bk.getPrefs()
         
        # save user selections
        if self.saveselection.get() == True:
            
            gui_prefs['convert_tags'] = self.converttags.get()
            if self.converttags.get() == True:
                options.CONVERT_TAGS = True
            else:
                options.CONVERT_TAGS = False 
                
            gui_prefs['remove_default_text_color'] = self.color.get()
            if self.color.get() == True:
                options.REMOVE_DEFAULT_TEXT_COLOR = True
            else:
                options.REMOVE_DEFAULT_TEXT_COLOR = False            
                
            gui_prefs['remove_default_BG_color'] = self.bgcolor.get()
            if self.bgcolor.get() == True:
                options.REMOVE_DEFAULT_BG_COLOR = True
            else:
                options.REMOVE_DEFAULT_BG_COLOR = False                                
                
            gui_prefs['preserve_imgsize'] = self.imgsize.get()
            if self.imgsize.get() == True:
                options.PRESERVE_IMG_SIZE = True
            else:
                options.PRESERVE_IMG_SIZE = False  

            gui_prefs['remove_unused_images'] = self.rm_images.get()
            if self.rm_images.get() == True:
                options.REMOVE_UNUSED_IMAGES = True
            else:
                options.REMOVE_UNUSED_IMAGES = False     

            gui_prefs['remove_breaks'] = self.removebr.get()
            if self.removebr.get() == True:
                options.REMOVE_HARD_BREAKS = True
            else:
                options.REMOVE_HARD_BREAKS = False
                
            gui_prefs['remove_nbsp_entities'] = self.remnbsp.get()
            if self.remnbsp.get() == True:
                options.REMOVE_NBSP_ENTITIES = True
            else:
                options.REMOVE_NBSP_ENTITIES = False     

            gui_prefs['remove_hyphen_props'] = self.rmhyphen.get()
            if self.rmhyphen.get() == True:
                options.REMOVE_HYPHEN_PROPS = True
            else:
                options.REMOVE_HYPHEN_PROPS = False                                  
                
            gui_prefs['remove_fonts'] = self.fonts.get()
            if self.fonts.get() == True:
                options.REMOVE_FONTS = True
            else:
                options.REMOVE_FONTS = False
                
            gui_prefs['remove_empty_paras'] = self.empty.get()
            if self.empty.get() == True:
                options.REMOVE_EMPTY_PARAS = True
            else:
                options.REMOVE_EMPTY_PARAS = False     

        self.bk.savePrefs(gui_prefs)
        self.destroy() 
        self.quit()
            
     
    def onCancel(self):
        options.SYS_EXIT = True
        self.destroy()  
        return(0)
       
        
