#!/Python3/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

import os, os.path, sys, shutil, inspect, re
from tempfile import mkdtemp    
import options
from decimal import *
import tkinter as tk
import tkinter.messagebox as mbox

try:
    from sigil_bs4 import BeautifulSoup, Comment
except:
    from bs4 import BeautifulSoup, Comment

__all__=["reduceDigitalZeros","addAltAttr2ImageTags","removeSectionTitleTags"]

    
def reduceDigitalZeros(line):
    
    # clean up large-sized decimal zero values in the css
    line = line.replace('.000000em','em')
    line = line.replace('.000000pt','pt')
    line = line.replace('.000000in','in')
    line = line.replace('.000000cm','cm')
    line = line.replace('.000000mm','mm')
    line = line.replace('.000000%','%')
    
    line = line.replace('.00000em','em')
    line = line.replace('.00000pt','pt')
    line = line.replace('.00000in','in')
    line = line.replace('.00000cm','cm')
    line = line.replace('.00000mm','mm')
    line = line.replace('.00000%','%')
    
    line = line.replace('.0000em','em')
    line = line.replace('.0000pt','pt')
    line = line.replace('.0000in','in')
    line = line.replace('.0000cm','cm') 
    line = line.replace('.0000mm','mm')
    line = line.replace('.0000%','%')
    
    line = line.replace('.000em','em')
    line = line.replace('.000pt','pt')
    line = line.replace('.000in','in')
    line = line.replace('.000cm','cm')
    line = line.replace('.000mm','mm')
    line = line.replace('.000%','%')
    
    line = line.replace('.00em','em')
    line = line.replace('.00pt','pt')
    line = line.replace('.00in','in')
    line = line.replace('.00cm','cm')
    line = line.replace('.00mm','mm')
    line = line.replace('.00%','%')
    return(line)        
    
    
def addAltAttr2ImageTags(wdir, file):
    """ Adds the alt attribute value to <img> image tags   
        which are all derived from the image file name.
    """
    
    output = os.path.join(wdir, 'add_img_attr.xhtml')
    outfp = open(output, 'wt', encoding=('utf-8'))
    html = open(file, 'rt', encoding='utf-8').read()
    soup = BeautifulSoup(html, 'html.parser')
    
    # strip and add "alt" values to all <img> tags 
    for tag in soup.find_all('img'):
        fname = os.path.basename(tag['src'])
        tag['alt'] = fname
        
    outfp.writelines(str(soup))
    outfp.close()
    os.remove(file)
    os.rename(output, file)
    return(0)
        
def removeSectionTitleTags(bk):
    
    for id, href in bk.text_iter():
        fdata = bk.readfile(id)
        soup = BeautifulSoup(fdata, 'html.parser')
    
        # delete all the current <title> tags
        for ttag in soup.find_all('title'):
            ttag.decompose()
        bk.writefile(id, str(soup))        
        
    return(0)
    
 
def addSectionTitleText(bk): 
    
    # remove all section <title> tags
    removeSectionTitleTags(bk)
    
    book_title = ''
    # get the book title from the metadata
    metadata = bk.getmetadataxml()
    lines = metadata.splitlines()
    for line in lines:
        if line.strip().startswith('<dc:title'):
            soup = BeautifulSoup(line, 'xml')
            book_title = soup.get_text()
            
    if book_title == '':
        book_title = 'Book Title'
    
    heading = ''
    search = ['p','h1','h2','h3','h4']
    for id, href in bk.text_iter():
        fdata = bk.readfile(id)
        soup = BeautifulSoup(fdata, 'html.parser')
        
        # create a new title tag for the file   
        for tag in soup.find_all('head'):    
            newtag = soup.new_tag('title')
            tag = tag.insert(1, newtag)
            
        # now get the first line of text with the chapter heading    
        for tag in soup.find_all(search):
            if tag.get_text() != None:
                heading = str(tag.get_text()).strip()
            else:
                heading = book_title            
            break
        
        # add the chapter heading string to the title tag
        if heading != None and heading != '':
            soup.title.string = heading
        else:
            soup.title.string = book_title
    
        bk.writefile(id, str(soup))

    return(0)
    
