/* 
 * Copyright (C) 2005 and 2006, Scott Turner scotty1024@mac.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import java.io.File;
import javax.swing.*;
import javax.swing.filechooser.*;

public class IconFilter extends FileFilter {

    // Accept all directories and all pdf, htm, html, xhtml files.
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }

	String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');

        if ((i > 0) &&  (i < s.length() - 1)) {
            ext = s.substring(i+1).toLowerCase();

            if (ext.equals("gif")) {
		return true;
	    }
        }

	return false;
    }

    // The description of this filter
    public String getDescription() {
        return "Book Icon Files";
    }
}