#----------------------------------------------------------------------------
# hThumbsPreview.py
#
# found following code here:  
# --> https://www.pythonguis.com/faq/file-image-browser-app-with-thumbnails/
# thanks a lot to Martin Fitzpatrick
#
# remove rows
# https://www.pythonguis.com/faq/remove-and-insertrow-for-martin-fitzpatricks-example/
#
# clearTable() is mine if something bad: my responsibility
# minor changes regarding QSize and CELL_PADDING
#----------------------------------------------------------------------------

import math
from collections import namedtuple
from PyQt5.QtCore import QAbstractTableModel, Qt, QSize
from PyQt5.QtWidgets import  QStyledItemDelegate

# Create a custom namedtuple class to hold our data.
preview = namedtuple("preview", "id title image")

NUMBER_OF_COLUMNS = 5
CELL_PADDING = 10 # all sides

class PreviewDelegate(QStyledItemDelegate):

    def paint(self, painter, option, index):
        # data is our preview object
        data = index.model().data(index, Qt.DisplayRole)
        if data is None:
            return

        width = option.rect.width() - CELL_PADDING * 2
        height = option.rect.height() - CELL_PADDING * 2
        
        # option.rect holds the area we are painting on the widget (our table cell)
        # scale our pixmap to fit
        scaled = data.image.scaled(
            width,
            height,
            aspectRatioMode=Qt.KeepAspectRatio,
        )
        # Position in the middle of the area.
        x = CELL_PADDING + (width - scaled.width()) / 2
        y = CELL_PADDING + (height - scaled.height()) / 2
        
#        painter.drawImage(option.rect.x() + x, option.rect.y() + y, scaled)
#       SCh change: integer required by drawImage
        painter.drawImage(int(option.rect.x() + x), int(option.rect.y() + y), scaled)

    def sizeHint(self, option, index):
        # All items the same size.
        return QSize(150, 100)



class PreviewModel(QAbstractTableModel):
    def __init__(self, todos=None):
        super().__init__()
        # .data holds our data for display, as a list of Preview objects.
        self.previews = []

    def data(self, index, role):
        try:
#            data = self.previews[index.row() * 4 + index.column() ]
#       SCh change: with NUMBER_OF_COLUMNS instead of 4 works with any number of cols
            data = self.previews[index.row() * NUMBER_OF_COLUMNS + index.column() ]
        except IndexError:
            # Incomplete last row.
            return

        if role == Qt.DisplayRole:
            return data   # Pass the data to our delegate to draw.

        if role == Qt.ToolTipRole:
            return data.title

    def columnCount(self, index):
        return NUMBER_OF_COLUMNS

    def rowCount(self, index):
        n_items = len(self.previews)
        return math.ceil(n_items / NUMBER_OF_COLUMNS)
        
    def removeRows(self, position, rows, QModelIndex):
        self.beginRemoveRows(QModelIndex, position, position+rows-1)
        for i in range(rows):
            del(self.previews[position])
        self.endRemoveRows()
        self.layoutChanged.emit()
        return True        

    def clearTable(self, locTable):
        index = locTable.currentIndex()
        rowCount= self.rowCount(1)
        try:
            for n in range (rowCount* NUMBER_OF_COLUMNS):
                self.removeRows(index.row(), 1, index) 
        except:
            pass

