#----------------------------------------------------------------------------
# hTabConfig.py
#
#   User I/F TABS config
#
#---------------------------------------------------------------------------- 
# import glob
from PyQt5.QtWidgets import (QPushButton,  QHBoxLayout, QVBoxLayout, QFormLayout,  QFrame,   
                             QWidget, QLabel, QSplitter,  QTextEdit,  QLineEdit, QTableWidget, 
                             QHeaderView,  QTableView,  QSizePolicy, QScrollArea,  QComboBox, 
                             QAbstractItemView)
from PyQt5.QtGui import QFont, QIcon
from PyQt5.QtCore import Qt,  pyqtSignal 
from PyQt5.QtGui import  QPixmap  

import hConstant as hC
from hQTableWidgetE import *
import hThumbsPreview as hTp

from PyQt5.Qsci import *


class LocQScrollArea(QScrollArea):
    redimImsgeSignal= pyqtSignal(int)
    def wheelEvent(self, event):
        if event.modifiers() & Qt.ControlModifier:
            direction= -1       # rotation backwards toward the user
            if event.angleDelta().y()> 0:
                direction= 1    # rotation forwards away from the user
            self.redimImsgeSignal.emit(direction)
        else:
            super().wheelEvent(event)



def addBkTestTab(self):
    tabName= "Mini editor"
    newTab = QWidget()
    newTab.setToolTip('Mini editor page')
    self.tabBar.addTab(newTab,  tabName)       
    #
    bkTestFrame= QFrame()
    bkTestFrame.setFrameStyle(QFrame.Box | QFrame.Sunken)  
    #
    self.editor= QsciScintilla()
    #
    self.setEditorProperties()
    #
    self.setMargins()
    #
    self.editor.setFolding(True)       
    self.editor.setFolding(QsciScintilla.BoxedTreeFoldStyle)
#        self.editor.setFolding(QsciScintilla.CircledTreeFoldStyle)     
    #
    # 1. Create a SQL lexer object
    self.lexer = QsciLexerPython(self.editor)
    # 2. init lexer (change some default)
    self.initLexer()
    # 3. Install the lexer into your editor
    self.editor.setLexer(self.lexer)    
    #
    editLayout= QHBoxLayout()
    editLayout.addWidget(self.editor)  
    #
    bkTestLoadScriptBtn= QPushButton('load script')
    bkTestLoadScriptBtn.setIcon(QIcon(self.iconPath+ 'script_add.png'))
    bkTestLoadScriptBtn.clicked.connect(self.loadPythonScript)
    bkTestLoadScriptBtn.setToolTip(hC.bkTestLoadScriptBtn)
    bkTestSaveScriptBtn= QPushButton('save script')
    bkTestSaveScriptBtn.setIcon(QIcon(self.iconPath+ 'script_save.png'))
    bkTestSaveScriptBtn.clicked.connect(self.savePythonScript)
    bkTestSaveScriptBtn.setToolTip(hC.bkTestSaveScriptBtn)
    bkTestRunScriptBtn= QPushButton('excute')
    bkTestRunScriptBtn.setIcon(QIcon(self.iconPath+ 'script_go.png'))
    bkTestRunScriptBtn.clicked.connect(self.runPythonScript)
    bkTestRunScriptBtn.setToolTip(hC.bkTestRunScriptBtn)    
    bkTestResetBtn= QPushButton('reset')
    bkTestResetBtn.setIcon(QIcon(self.iconPath+ 'refresh.png'))
    bkTestResetBtn.clicked.connect(lambda: self.editor.clear())
    bkTestResetBtn.setToolTip(hC.bkTestResetBtn)     
    #
    bkTestBtnLayout= QHBoxLayout()
    bkTestBtnLayout.addWidget(bkTestLoadScriptBtn)   
    bkTestBtnLayout.addWidget(bkTestSaveScriptBtn)
    bkTestBtnLayout.addStretch()
    bkTestBtnLayout.addWidget(bkTestRunScriptBtn)
    bkTestBtnLayout.addWidget(bkTestResetBtn)   
    #
    mainLayout= QVBoxLayout()
    mainLayout.addLayout(bkTestBtnLayout)
    mainLayout.addLayout(editLayout)
    #
    newTab.setLayout(mainLayout)      
   

def addMiscPages(self):
    tabName= "Misc pages"
    newTab = QWidget()
    newTab.setToolTip('add different pages to book')
    self.tabBar.addTab(newTab,  tabName)     
    #
    # widget to choose page type and start creation
    miscPagesLbl= QLabel('choose page type   ')
    miscPagesLst= ['title', 'half', 'copyright', 'dedication',  'alsoBy', 'epigraph', 'TOC']
    # page COMBO
    self.miscPagesCombo= QComboBox()
    self.miscPagesCombo.addItems(miscPagesLst)
#    self.miscPagesCombo.currentTextChanged.connect(self.miscPagesComboChanged)
    createPageBtn= QPushButton('load page into Sigil')
    createPageBtn.setIcon(QIcon(self.iconPath+ 'sigil.ico'))
    createPageBtn.clicked.connect(self.loadMiscPageIntoSigil)
    createPageBtn.setToolTip(hC.createPageBtn)
    setPageTypeLayout= QHBoxLayout()
    setPageTypeLayout.addWidget(miscPagesLbl)
    setPageTypeLayout.addWidget(self.miscPagesCombo)
    setPageTypeLayout.addStretch()
    setPageTypeLayout.addWidget(createPageBtn)
    
    #--------------------------------------------------- 
    #   table to set page param
    #--------------------------------------------------- 
    miscParamFrame= QFrame()
    miscParamFrame.setFrameStyle(QFrame.Box | QFrame.Sunken)  
    
    self.addRowMiscPageBtn= QPushButton('add block')
    self.addRowMiscPageBtn.setIcon(QIcon(self.iconPath+ 'tableRowInsert.png'))
    self.addRowMiscPageBtn.clicked.connect(self.addBlockToMiscPageTable)
    self.addRowMiscPageBtn.setToolTip(hC.addRowMiscPageBtn)
    self.delRowMiscPageBtn= QPushButton('delete block')
    self.delRowMiscPageBtn.setIcon(QIcon(self.iconPath+ 'tableRowDelete.png'))
    self.delRowMiscPageBtn.clicked.connect(self.deleteBlockMiscPage)
    self.delRowMiscPageBtn.setToolTip(hC.delRowMiscPageBtn)
    resetTableBtn= QPushButton('reset table')
    resetTableBtn.setIcon(QIcon(self.iconPath+ 'tableDelete.png'))
    resetTableBtn.clicked.connect(self.clearMiscPageTable)
    resetTableBtn.setToolTip(hC.resetTableBtn)
    updateXhtmlBtn= QPushButton('create XHTML')
    updateXhtmlBtn.setIcon(QIcon(self.iconPath+ 'htmlAdd.png'))
    updateXhtmlBtn.clicked.connect(self.updateXHTML)
    updateXhtmlBtn.setToolTip(hC.updateXhtmlBtn)
    
    miscParamBtnLayout= QHBoxLayout()
    miscParamBtnLayout.addWidget(self.addRowMiscPageBtn) 
    miscParamBtnLayout.addWidget(self.delRowMiscPageBtn)   
    miscParamBtnLayout.addWidget(resetTableBtn)
    miscParamBtnLayout.addStretch()
    miscParamBtnLayout.addWidget(updateXhtmlBtn)
    # table def
    tabHeadLst= ['row',  'value']
    self.miscPageTblW= QTableWidgetE(0, len(tabHeadLst), self.bk)
    self.miscPageTblW.tableSetHeader(self.miscPageTblW, tabHeadLst)
    self.miscPageTblW.horizontalHeader().setSectionResizeMode(QHeaderView.ResizeToContents)
    # defines table cell edit mode
    self.miscPageTblW.setEditTriggers(QAbstractItemView.AllEditTriggers)

    self.miscPageTblW.btnChooseImg.connect(self.signalPublisherImgReceived)
    horizontalHeader = self.miscPageTblW.horizontalHeader()
    # resize the first column to 100 pixels
    horizontalHeader.resizeSection(0, 250)
    # adjust the second column to its contents
    horizontalHeader.setSectionResizeMode(1, QHeaderView.ResizeToContents)

    miscParamLayout= QVBoxLayout()
    miscParamLayout.addLayout(miscParamBtnLayout)
    miscParamLayout.addWidget(self.miscPageTblW)
       
    miscParamFrame.setLayout(miscParamLayout)
    
    #--------------------------------------------------- 
    #   XHTML QTextEdit and page preview
    #--------------------------------------------------- 
    xhtmlFrame= QFrame()
    xhtmlFrame.setFrameStyle(QFrame.Box | QFrame.Sunken)   
    
    self.miscPagePreviewBtn= QPushButton(' preview')
    self.miscPagePreviewBtn.setIcon(QIcon(self.iconPath+ 'preview.png'))
    self.miscPagePreviewBtn.clicked.connect(self.miscPagePreviewClicked)
    self.miscPagePreviewBtn.setToolTip(hC.miscPagePreviewBtn)
    
    btnLayout= QHBoxLayout()
    btnLayout.addStretch()
    btnLayout.addWidget(self.miscPagePreviewBtn)
    
    self.xhtmlTEdit= QTextEdit()
    self.xhtmlTEdit.setReadOnly(True)
    
    xhtmlLayout= QVBoxLayout()
    xhtmlLayout.addLayout(btnLayout)
    xhtmlLayout.addWidget(self.xhtmlTEdit)
    #
    widgetLayout= QVBoxLayout()
    widgetLayout.addLayout(miscParamLayout)    
    widgetLayout.addLayout(xhtmlLayout)

    xhtmlFrame.setLayout(widgetLayout)

    #--------------------------------------------------- 
    #   main layout
    #---------------------------------------------------     
    mainSplitter= QSplitter(Qt.Vertical)      
    mainSplitter.addWidget(miscParamFrame)
    mainSplitter.addWidget(xhtmlFrame)
    #
    mainLayout= QVBoxLayout()
    mainLayout.addLayout(setPageTypeLayout)    
    mainLayout.addLayout(setPageTypeLayout)
    mainLayout.addWidget(mainSplitter)
    #
    newTab.setLayout(mainLayout)  
 


def addTabManifest(self):
    tabName= "Sigil MANIFEST"
    newTab = QWidget()
    newTab.setToolTip('list of all Manifest entries')
    self.tabBar.addTab(newTab,  tabName) 
    #
    manifestFrame= QFrame()
    manifestFrame.setFrameStyle(QFrame.Box | QFrame.Sunken)    

    #------------------------------------------------------------------
    self.manifestTblW= QTableWidgetE(0, len(hC.manifestTableHeadLst), self.bk)
    #
    self.manifestTblW.horizontalHeader().setSectionResizeMode(QHeaderView.ResizeToContents) 
    self.manifestTblW.cellClicked.connect(self.manifestTblW.tableCellClicked) 

    self.tabBarChanged(hC.TAB_BAR_NR_MANIFEST)    

    tableLayout= QHBoxLayout()
    tableLayout.addWidget(self.manifestTblW)
    #
    #------------------------------------------------------------------    
    manifestFrame.setLayout(tableLayout)
    #
    mainLayout= QVBoxLayout()
    mainLayout.addWidget(manifestFrame)
    #
    newTab.setLayout(mainLayout)    
    
    

def addTabImageTools(self):
    tabName= "Images tools"
    #   create new TAB
    newTab = QWidget()
    newTab.setToolTip('image tab management')
    self.tabBar.addTab(newTab,  tabName)
    
    
    #--------------------------------------------------- 
    #   image a) choose & preview     b) load into Sigil 
    #---------------------------------------------------
    imgLoadFrame= QFrame()
    imgLoadFrame.setFrameStyle(QFrame.Box | QFrame.Sunken)
    # labels to contain image path and pixels
    self.imgPathLbl= QLabel()           # init value in resetImageInToolTab()
    self.imgDimInPixel= QLabel('')      # init value in resetImageInToolTab()
    imgDescrLayout= QHBoxLayout()
    imgDescrLayout.addStretch()
    imgDescrLayout.addWidget(self.imgPathLbl)
    imgDescrLayout.addStretch()
    imgDescrLayout.addWidget(self.imgDimInPixel)
    imgDescrLayout.addStretch()
    # label to contain image
    self.imgLoaded = QPixmap()
    self.imageLoadedLbl = QLabel('')
    self.imageLoadedLbl.setMinimumHeight (1000) # required to have scroll bar in imageLoadedLblScrollA
    self.imageLoadedLbl.setAlignment(Qt.AlignHCenter )
    # Use setSizePolicy to specify how the widget can be resized, horizontally and vertically. Here, the image will stretch horizontally, but not vertically.
    self.imageLoadedLbl.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Ignored)
    # scroll area for image
    self.imageLoadedLblScrollA= LocQScrollArea()     
    self.imageLoadedLblScrollA.redimImsgeSignal.connect(self.redimWheelEvent) 
    self.imageLoadedLblScrollA.setVerticalScrollBarPolicy(Qt.ScrollBarAlwaysOn)
    self.imageLoadedLblScrollA.setWidgetResizable(True)
    self.imageLoadedLblScrollA.setWidget(self.imageLoadedLbl)
    scrollaAreaLayout= QVBoxLayout()
    scrollaAreaLayout.setContentsMargins(2, 2, 2, 2)    
    # btn to choose and load image
    self.btnChooseImage= QPushButton('choose image')
    self.btnChooseImage.clicked.connect(self.loadAndPreviewImage)
    self.btnChooseImage.setIcon(QIcon(self.iconPath+ 'image.png')) 
    self.btnChooseImage.setToolTip(hC.btnChooseImage)
    self.btnLoadImage= QPushButton('load image into Sigil')
    self.btnLoadImage.setIcon(QIcon(self.iconPath+ 'sigil.ico'))
    self.btnLoadImage.clicked.connect(self.loadImageToSigil)
    self.btnLoadImage.setToolTip(hC.btnLoadImage)
    # thumbnails btn (here because initialised in resetImageInToolTab()
    self.creatThumbXhtmlBtn= QPushButton('create xhtml')
    self.creatThumbXhtmlBtn.setIcon(QIcon(self.iconPath+ 'html.png'))
    self.creatThumbXhtmlBtn.clicked.connect(self.createXhtmlFromThumb)
    self.creatThumbXhtmlBtn.setToolTip(hC.creatThumbXhtmlBtn)
    #
    btnResetImage= QPushButton('clear image')
    btnResetImage.setIcon(QIcon(self.iconPath+ 'imageDelete.png'))
    btnResetImage.clicked.connect(self.resetImageInToolTab) 
    btnResetImage.setToolTip(hC.btnResetImage)
    # call reset... to init some button and labels
    self.resetImageInToolTab()
    #
    btnLayout= QHBoxLayout()
    btnLayout.addWidget(self.btnChooseImage)
    btnLayout.addWidget(self.btnLoadImage) 
    btnLayout.addStretch()
    btnLayout.addWidget(btnResetImage)
    #
    scrollaAreaLayout.addLayout(btnLayout)
    scrollaAreaLayout.addLayout(imgDescrLayout)
    scrollaAreaLayout.addWidget(self.imageLoadedLblScrollA)  
    imgLoadFrame.setLayout(scrollaAreaLayout)   
    
    #----------------------------------------------------
    # shows thumbnails of images already loaded in Sigil
    #----------------------------------------------------
    thumbTableFrame= QFrame()
    thumbTableFrame.setFrameStyle(QFrame.Box | QFrame.Sunken) 
    #
    btnLayout= QHBoxLayout()
    btnLayout.addWidget(self.creatThumbXhtmlBtn)   
    btnLayout.addStretch()
    # create QTableView to display thumbnails
    self.thumbTableView = QTableView()
    self.thumbTableView.clicked.connect(self.clickedTableView)    
    thumbTableLayout= QVBoxLayout()
    thumbTableLayout.addLayout(btnLayout)
    thumbTableLayout.addWidget(self.thumbTableView)
    #
    thumbTableFrame.setLayout(thumbTableLayout)
    #
    self.thumbTableView.horizontalHeader().hide()
    self.thumbTableView.verticalHeader().hide()     
    #
    delegate = hTp.PreviewDelegate()
    self.thumbTableView.setItemDelegate(delegate)
    self.model = hTp.PreviewModel()
    self.thumbTableView.setModel(self.model)
    #
    self.thumbPreviewRefresh()
    #----------------------------------------------------
    #
    mainSplitter= QSplitter(Qt.Vertical)      
    mainSplitter.addWidget(imgLoadFrame)
    mainSplitter.addWidget(thumbTableFrame)
    #
    mainLayout= QVBoxLayout()
    mainLayout.addWidget(mainSplitter)
    #
    newTab.setLayout(mainLayout)  


def addTabSigilSpine(self):
    tabName= "Sigil SPINE"
    #   create new TAB
    newTab = QWidget()
    newTab.setToolTip('tab to configure Sigil SPINE')
    self.tabBar.addTab(newTab,  tabName)
    #
    spineFrame= QFrame()
    spineFrame.setFrameStyle(QFrame.Box | QFrame.Sunken)     
    #
    saveToSigilBtn= QPushButton('save to Sigil')
    saveToSigilBtn.setIcon(QIcon(self.iconPath+ 'sigil.ico'))
    saveToSigilBtn.clicked.connect(self.spineSaveToSigil)
    saveToSigilBtn.setToolTip(hC.saveToSigilBtn)
    deleteSelectedBtn= QPushButton('delete selected row')
    deleteSelectedBtn.setIcon(QIcon(self.iconPath+ 'tableRowDelete.png')) 
    deleteSelectedBtn.clicked.connect(self.spineTabRemoveRow)
    deleteSelectedBtn.setToolTip(hC.deleteSelectedBtn)
    #
    generalBtnLayout= QHBoxLayout()
    generalBtnLayout.addWidget(saveToSigilBtn)
    generalBtnLayout.addStretch()
    generalBtnLayout.addWidget(deleteSelectedBtn)
    
    #------------------------------------------------------------------
    self.spineTblW= QTableWidgetE(0, len(hC.tableHeadLst), self.bk)
    #
    self.spineTblW.horizontalHeader().setSectionResizeMode(QHeaderView.ResizeToContents) 
    self.spineTblW.cellClicked.connect(self.spineTblW.tableCellClicked) 
    #
    self.tabBarChanged(hC.TAB_BAR_NR_SIGIL)

    upBtn= QPushButton()
    upBtn.setIcon(QIcon(self.iconPath+ 'arrowUp.png')) 
    upBtn.clicked.connect(lambda: self.spineTblW.tableMoveRow(self.spineTblW, TABLE_MOVE_UP))        
    upBtn.setToolTip(hC.upBtn)
    downBtn= QPushButton()
    downBtn.setIcon(QIcon(self.iconPath+ 'arrowDown.png'))      
    downBtn.clicked.connect(lambda: self.spineTblW.tableMoveRow(self.spineTblW, TABLE_MOVE_DOWN)) 
    downBtn.setToolTip(hC.downBtn)
    startBtn= QPushButton()
    startBtn.setIcon(QIcon(self.iconPath+ 'arrowStart.png'))        
    startBtn.clicked.connect(lambda: self.spineTblW.tableMoveRow(self.spineTblW, TABLE_MOVE_START))   
    startBtn.setToolTip(hC.startBtn)
    bottomBtn= QPushButton()
    bottomBtn.setIcon(QIcon(self.iconPath+ 'arrowEnd.png'))          
    bottomBtn.clicked.connect(lambda: self.spineTblW.tableMoveRow(self.spineTblW, TABLE_MOVE_END))     
    bottomBtn.setToolTip(hC.bottomBtn)
    #
    upDownLayout= QVBoxLayout()
    upDownLayout.addStretch()
    upDownLayout.addWidget(startBtn)
    upDownLayout.addWidget(upBtn)
    upDownLayout.addWidget(downBtn)
    upDownLayout.addWidget(bottomBtn)        
    upDownLayout.addStretch()
    
    tableAndBtnLayout= QHBoxLayout()
    tableAndBtnLayout.addLayout(upDownLayout)
    tableAndBtnLayout.addWidget(self.spineTblW)
    #
    #------------------------------------------------------------------    
    spineFrame.setLayout(tableAndBtnLayout)
    #
    mainLayout= QVBoxLayout()
    mainLayout.addLayout(generalBtnLayout)
    mainLayout.addWidget(spineFrame)
    #
    newTab.setLayout(mainLayout)

def addTabTranslationOneStep(self):
    tabName= "Preview translation"
    newTab = QWidget()
    newTab.setToolTip('docx translation results')
    self.tabBar.addTab(newTab,  tabName) 

    #------------------------------------------------------------------
    htmFrame= QFrame()
    htmFrame.setFrameStyle(QFrame.Box | QFrame.Sunken)
    self.htmTextEdit= QTextEdit()
    self.htmTextEdit.setStyleSheet("QTextEdit { background-color:#f0f0f0; }")
    self.htmTextEdit.setFont(QFont('COURIER NEW', 10))
    htmTextEditLayout= QVBoxLayout()
    htmTextEditLayout.setContentsMargins(2, 2, 2, 2)    
    htmEditBtn= QPushButton('edit')
    htmEditBtn.setIcon(QIcon(self.iconPath+ 'edit.png')) 
    htmEditBtn.clicked.connect(lambda: self.tabTranslationEdit('htm'))
    htmEditBtn.setToolTip(hC.htmEditBtn)
    self.htmPreviewBtn= QPushButton('Preview')
    self.htmPreviewBtn.setIcon(QIcon(self.iconPath+ 'preview.png'))
    self.htmPreviewBtn.clicked.connect(lambda: self.tabTranslationPreview('htm'))
    self.htmPreviewBtn.setToolTip(hC.htmPreviewBtn)
    self.htmTextEditLbl= QLabel('htm file')
    htmLayout= QHBoxLayout()
    htmLayout.addWidget(self.htmTextEditLbl)
    htmLayout.addStretch()        
    htmLayout.addWidget(self.htmPreviewBtn)   
    htmLayout.addWidget(htmEditBtn)  
    
    htmTextEditLayout.addLayout(htmLayout)
    htmTextEditLayout.addWidget(self.htmTextEdit)  
    htmFrame.setLayout(htmTextEditLayout)    
    #
    #------------------------------------------------------------------    
    mainLayout= QVBoxLayout()
    mainLayout.addWidget(htmFrame)
    #
    newTab.setLayout(mainLayout)         
    
 
def addTabDocument(self):
    tabName= "Translation"
    #   create new TAB
    newTab = QWidget()
    newTab.setToolTip('tab to configure docx file to translate')
    self.tabBar.addTab(newTab,  tabName)
    #   create tab buttons
    chooseDocxBtn= QPushButton('choose .docx')
    chooseDocxBtn.setIcon(QIcon(self.iconPath+ 'wordChoose.png'))
    chooseDocxBtn.setToolTip(hC.tabDocChooseDocxBtn)
    chooseDocxBtn.clicked.connect(lambda: self.chooseFileTabDoc('docx', hC.filterDocx, 'tabDoc'))
    self.startTranslationBtn= QPushButton('start translation')
    self.startTranslationBtn.setIcon(QIcon(self.iconPath+ 'start.png')) 
    self.startTranslationBtn.setToolTip(hC.tabDocStartTranslationBtn)
    self.startTranslationBtn.clicked.connect(self.startTranslationOneStepTabDoc)
    self.startTranslationBtn.setEnabled(False)
    self.uploadSigilBtn= QPushButton('load into Sigil')
    self.uploadSigilBtn.setIcon(QIcon(self.iconPath+ 'sigil.ico')) 
    self.uploadSigilBtn.clicked.connect(self.uploadDocInSigil) 
    self.uploadSigilBtn.setToolTip(hC.uploadSigilBtn)
    self.uploadSigilBtn.setEnabled(False) 
    # fontObj defined in pluginMemu.py
    self.fontComboBox= QComboBox()
    self.fontComboBox.setEditable(True)
    # getting the line edit of combo box
    self.lineEdit = self.fontComboBox.lineEdit()
    self.fontComboBox.addItems(self.fontObj.familyLst)   
    #   
    self.fontComboBox= QComboBox()
    # getting the line edit of combo box
    self.fontComboBox.setEditable(True)
    self.lineEdit = self.fontComboBox.lineEdit()
    self.fontComboBox.addItems(self.fontObj.familyLst)
    #   fonts in combobox 
    self.setFontsInCombo(self.fontComboBox)      
    #
    self.sizeComboBox= QComboBox()
    #
    self.sampleLbl= QLabel('AaBbYyZz')
    self.initSampleLabel(self.sampleLbl) 
    lblLayout=QHBoxLayout()
    #
    lblLayout.addStretch()
    lblLayout.addWidget(self.sampleLbl)  
    #
    self.fontComboBox.currentTextChanged.connect(lambda: self.currentTextChangedFont(self.sizeComboBox, 
                self.sampleLbl, self.lineEdit, self.fontComboBox.currentText()))
    #
    locFamily= self.currentFontFamily       #self.defaultFontFamilyComboBox.currentText()
    self.fontComboBox.setCurrentText(locFamily)
    #
    self.sizeInitFlag= True
    self.sizeComboBox.currentTextChanged.connect(lambda: self.currentTextChangedSize(self.sampleLbl, 
                self.sizeInitFlag, self.sizeComboBox.currentText()))
    #
    resetParamBtn= QPushButton('reset param')
    resetParamBtn.setIcon(QIcon(self.iconPath+ 'restoreDef.png')) 
    resetParamBtn.setToolTip(hC.tabDocResetParamBtn)
    resetParamBtn.clicked.connect(lambda: self.resetParamTabDoc('tabDoc'))
    #
    resetFontDefaultBtn= QPushButton('default font')
    resetFontDefaultBtn.setIcon(QIcon(self.iconPath+ 'restoreDef.png')) 
    resetFontDefaultBtn.clicked.connect(self.resetFontDefault)
    #
    btnLayout= QHBoxLayout()
    btnLayout.addWidget(chooseDocxBtn)
    btnLayout.addWidget(self.startTranslationBtn)
    btnLayout.addWidget(self.uploadSigilBtn)
    btnLayout.addWidget(resetParamBtn)      
    btnLayout.addStretch()
    btnLayout.addWidget(self.fontComboBox)
    btnLayout.addWidget(self.sizeComboBox) 
    btnLayout.addWidget(resetFontDefaultBtn)
    #
    #   create widgets to display .docx working parameters
    self.configWordDocLineEdit= QLineEdit()
    self.configHtmFileLineEdit= QLineEdit()            
    self.configWordStartPageLineEdit= QLineEdit()     
    self.configWordEndPageLineEdit= QLineEdit()     
    self.configCsvLineEdit= QLineEdit()   
    #
    configWordDocLbl= QLabel('Word file path')
    configHtmFileLbl= QLabel('File HTM')               
    configWordStarPagetLbl= QLabel('Word doc start page')        
    configWordEndPagetLbl= QLabel('Word doc end page')         
    configCsvLbl= QLabel('Csv file')         
    #
    self.tabDocParamLst.append((self.configWordDocLineEdit, configWordDocLbl))
    self.tabDocParamLst.append((self.configHtmFileLineEdit, configHtmFileLbl))
    self.tabDocParamLst.append((self.configWordStartPageLineEdit, configWordStarPagetLbl))
    self.tabDocParamLst.append((self.configWordEndPageLineEdit, configWordEndPagetLbl))
    self.tabDocParamLst.append((self.configCsvLineEdit, configCsvLbl))
    # disable lineEdit 
    for lineEdit, label in self.tabDocParamLst:
        lineEdit.setStyleSheet('background-color:'+ hC.liteGreyColor)
        lineEdit.setReadOnly(True)
    #
    paramLayout= QFormLayout()
    paramLayout.addRow(configWordDocLbl, self.configWordDocLineEdit)
    paramLayout.addRow(configHtmFileLbl, self.configHtmFileLineEdit)
    paramLayout.addRow(configWordStarPagetLbl, self.configWordStartPageLineEdit)
    paramLayout.addRow(configWordEndPagetLbl, self.configWordEndPageLineEdit)
    paramLayout.addRow(configCsvLbl, self.configCsvLineEdit)
    #   create new table
    self.csvValueTable= QTableWidget(1, hC.CSV_TABLE_NUM_COL, self)
    self.csvValueTable.setToolTip(hC.csvValueTableTip)
    self.csvValueTable.horizontalHeader().setSectionResizeMode(QHeaderView.ResizeToContents)             
    self.csvValueTable.cellClicked.connect(self.selectedTableCell)
    self.csvValueTable.setStyleSheet('background-color:'+ hC.liteGreyColor)
    #   create and populate layout for the new TAB
    tabLayout= QVBoxLayout()
    tabLayout.addWidget(self.csvValueTable)
    mainLayout= QVBoxLayout()
    mainLayout.addLayout(btnLayout)
    mainLayout.addLayout(lblLayout)
    mainLayout.addLayout(paramLayout)
    mainLayout.addLayout(tabLayout)
    
    newTab.setLayout(mainLayout)



def addTabConfig(self):
    tabName= "Config"
    # create new TAB
    newTab = QWidget()
    newTab.setToolTip(hC.tabWorkConfig)
    self.tabBar.addTab(newTab,  tabName)
    # 
    wordBtn= QPushButton('set WinWord exe')
    wordBtn.setIcon(QIcon(self.iconPath+ 'wordExe.png'))
    wordBtn.clicked.connect(lambda: self.baseConfigTabConfig('w', hC.filterExe) )
    wordBtn.setToolTip(hC.tabWorkWordBtn)
    editorBtn= QPushButton('set Editor exe')
    editorBtn.setIcon(QIcon(self.iconPath+ 'editExe.png'))  
    editorBtn.clicked.connect(lambda: self.baseConfigTabConfig('e', hC.filterExe) )  
    editorBtn.setToolTip(hC.tabWorkEditorBtn)
    workingDirBtn= QPushButton('set Working folder') 
    workingDirBtn.setIcon(QIcon(self.iconPath+ 'workingFolder.png'))
    workingDirBtn.clicked.connect(lambda: self.baseConfigTabConfig('d')) 
    workingDirBtn.setToolTip(hC.tabWorkWorkingDirBtn)
    saveParamBtn= QPushButton('save settings')
    saveParamBtn.setIcon(QIcon(self.iconPath+ 'saveSettings.png'))
    saveParamBtn.clicked.connect(lambda: self.saveLoadSettings('save')) 
    saveParamBtn.setToolTip(hC.saveParamBtn)
    loadParamBtn= QPushButton('load settings')
    loadParamBtn.setIcon(QIcon(self.iconPath+ 'table_add.png'))
    loadParamBtn.clicked.connect(lambda: self.saveLoadSettings('load'))  
    loadParamBtn.setToolTip(hC.loadParamBtn)
    restoreDefaultBtn= QPushButton('Restore default')
    restoreDefaultBtn.clicked.connect(self.restoreDefaultTabConfig)
    restoreDefaultBtn.setIcon(QIcon(self.iconPath+ 'restoreDef.png'))   
    restoreDefaultBtn.setToolTip(hC.tabWorkRestoreDefaultBtn)
    #
    btnLayout= QHBoxLayout()
    btnLayout.addWidget(wordBtn)
    btnLayout.addWidget(editorBtn)
    btnLayout.addWidget(workingDirBtn)
    btnLayout.addStretch()
    btnLayout.addWidget(saveParamBtn)
    btnLayout.addWidget(loadParamBtn)
    btnLayout.addWidget(restoreDefaultBtn)
    #
    winWordExeLbl= QLabel('WinWord exe path')
#    winWordExeLbl.setVisible(False)
    editorExeLbl= QLabel('Editor exe path')
    workingDirPathLbl= QLabel('Working dir Path')
    docxSplitStyleLbl= QLabel('docx split style')
    docxNameChapStrLbl= QLabel('docx chapter string')
    #
    self.winWordExeLineE= QLineEdit(hC.winWordExePath)
#    self.winWordExeLineE.setVisible(False)
    self.editorExeLineE= QLineEdit(hC.editorExePath)
    self.workingDirPathLineE= QLineEdit(hC.workingDir)   
    self.docxSplitStyleLineE= QLineEdit(hC.CSV_STYLE_TO_SEARCH)
    self.docxNameChapStrLineE= QLineEdit(hC.CHAPTER)
    #   for futher checks
    self.tabConfParamLst.append((self.winWordExeLineE, winWordExeLbl))
    self.tabConfParamLst.append((self.editorExeLineE, editorExeLbl))
    self.tabConfParamLst.append((self.workingDirPathLineE, workingDirPathLbl))
    #   disable lineEdit
    for lineEdit,  label in self.tabConfParamLst:
        lineEdit.setStyleSheet('background-color:'+ hC.liteGreyColor)
        lineEdit.setReadOnly(True)
    #
    tabLayout= QFormLayout()
    tabLayout.addRow(winWordExeLbl,  self.winWordExeLineE)
    tabLayout.addRow(editorExeLbl,  self.editorExeLineE)
    tabLayout.addRow(workingDirPathLbl,  self.workingDirPathLineE)
    #
    docxSplitLayout= QFormLayout()
    docxSplitLayout.addRow(docxSplitStyleLbl, self.docxSplitStyleLineE)
    docxSplitLayout.addRow(docxNameChapStrLbl, self.docxNameChapStrLineE)
    # --- .csv file creation
    chooseDocxBtn= QPushButton('choose .docx')
    chooseDocxBtn.setIcon(QIcon(self.iconPath+ 'wordChoose.png'))
    chooseDocxBtn.setToolTip(hC.tabDocChooseDocxBtn)
    chooseDocxBtn.clicked.connect(lambda: self.chooseFileTabDoc('docx', hC.filterDocx, 'tabConf'))    
    self.createCsvBtn= QPushButton('create .csv')
    self.createCsvBtn.setIcon(QIcon(self.iconPath+ 'createCsv.png'))
    self.createCsvBtn.setToolTip(hC.tabDocCreateCsvBtn)
    self.createCsvBtn.setEnabled(False)
    self.createCsvBtn.clicked.connect(self.createCsvTabDoc)
    resetParamBtn= QPushButton('reset param')
    resetParamBtn.setIcon(QIcon(self.iconPath+ 'restoreDef.png')) 
    resetParamBtn.setToolTip(hC.tabDocResetParamBtn)
    resetParamBtn.clicked.connect(lambda: self.resetParamTabDoc('tabConf'))
    btnCsvLayout= QHBoxLayout()
    btnCsvLayout.addWidget(chooseDocxBtn)
    btnCsvLayout.addWidget(self.createCsvBtn)
    btnCsvLayout.addStretch()
    btnCsvLayout.addWidget(resetParamBtn)
    #
    tabConfigDocxLbl= QLabel('.docx file')
    self.tabConfigDocxLineEdit= QLineEdit()
    self.tabConfigDocxLineEdit.setStyleSheet('background-color:'+ hC.liteGreyColor)
    self.tabConfigDocxLineEdit.setReadOnly(True)
    tabConfigCsvLbl= QLabel('.csv file')
    self.tabConfigCsvLineEdit= QLineEdit()
    self.tabConfigCsvLineEdit.setStyleSheet('background-color:'+ hC.liteGreyColor)
    self.tabConfigCsvLineEdit.setReadOnly(True)
    tabConfigCsvLayout= QFormLayout()
    tabConfigCsvLayout.addRow(tabConfigDocxLbl, self.tabConfigDocxLineEdit)
    tabConfigCsvLayout.addRow(tabConfigCsvLbl,  self.tabConfigCsvLineEdit)
    #
    #   font settings 
    defaultFontLbl= QLabel('default font')
    #
    self.defaultFontFamilyComboBox= QComboBox()
    # getting the line edit of combo box
    self.defaultFontFamilyComboBox.setEditable(True)
    self.defaultLineEdit = self.defaultFontFamilyComboBox.lineEdit()
    self.defaultFontFamilyComboBox.addItems(self.fontObj.familyLst)
    #   fonts in combobox 
    self.setFontsInCombo(self.defaultFontFamilyComboBox)      
    #
    self.defaultFontSizeComboBox= QComboBox()
    #
    self.defaultFontSampleLbl= QLabel('AaBbYyZz')
    self.initSampleLabel(self.defaultFontSampleLbl)   
    #
    self.defaultFontFamilyComboBox.currentTextChanged.connect(lambda: self.currentTextChangedFont(self.defaultFontSizeComboBox, 
                self.defaultFontSampleLbl, self.defaultLineEdit, self.defaultFontFamilyComboBox.currentText()))
    #
    self.defaultSizeInitFlag= True
    self.defaultFontSizeComboBox.currentTextChanged.connect(lambda: self.currentTextChangedSize(self.defaultFontSampleLbl, 
                self.defaultSizeInitFlag, self.defaultFontSizeComboBox.currentText()))
    #
    fontLayout= QHBoxLayout()
    fontLayout.addWidget(defaultFontLbl)
    fontLayout.addWidget(self.defaultFontFamilyComboBox)
    fontLayout.addWidget( self.defaultFontSizeComboBox)
    fontLayout.addStretch()
    sampleLayout= QHBoxLayout()
    sampleLayout.addStretch()
    sampleLayout.addWidget(self.defaultFontSampleLbl)
    sampleLayout.addStretch()
    #
    emptyLayout= QHBoxLayout()
    emptyLbl= QLabel(10*' ')
    emptyLayout.addWidget(emptyLbl)
    #
    mainLayout= QVBoxLayout()
    mainLayout.addLayout(btnLayout)
    mainLayout.addLayout(docxSplitLayout)    
    mainLayout.addLayout(tabLayout)  
#    mainLayout.addLayout(docxSplitLayout) 
    mainLayout.addLayout(fontLayout)
    mainLayout.addLayout(sampleLayout)
    mainLayout.addLayout(emptyLayout)
    mainLayout.addLayout(btnCsvLayout)    
    mainLayout.addLayout(tabConfigCsvLayout)    
    #
    newTab.setLayout(mainLayout)
    #
    self.saveLoadSettings('load')     
