#-------------------------------------------------------
#  hSigilBkUtil.py
#-------------------------------------------------------
import sys
from PyQt5.QtWidgets import QMessageBox
from PyQt5.QtCore import pyqtSignal,  QObject

import hConstant as hC


debugErrMsg= '*bk functions NOT usable in DEBUG mode\n'


class BkUtil(QObject):
    errorMsgSignal= pyqtSignal(str)
    def __init__(self):
        super().__init__()
                
    def bkSearchManifestId(self, locBk, manifestIdToSearch):
        '''
            searches for manifestIdToSearch in manifest iterator. 
            Returns manifestIdToSearch if found, else ''
        '''
        manifestId= ''
        if hC.DEBUG:
            self.errorMsgSignal.emit(debugErrMsg+ 'bkSearchManifestId')
        else:
            try:
                for manifestId, hrefOPF, mediaType in locBk.manifest_iter():
                    if manifestIdToSearch== manifestId:
                        return manifestId
                manifestId= ''      # avoid ncx
            except:
                err= '*searchManifestId\n'+ str(sys.exc_info()[0])+ '\n'+ str(sys.exc_info()[1])+ '\n'+ str(sys.exc_info()[2])
                self.errorMsgSignal.emit(err)
                manifestId= ''
        return manifestId

    def bkDeleteFile(self, locBk, manifestIdToDelete):
        '''
            remove manifestIdToDelete from manifest AND from spine
        '''  
        deleted= False
        if hC.DEBUG:
            self.errorMsgSignal.emit(debugErrMsg+ 'bkDeleteFile')
        else:    
            try:
                locBk.deletefile(manifestIdToDelete)  
#                print('deleted ',  manifestIdToDelete)
                deleted= True
            except:
                err= '*bkDeleteFile\n'+ str(sys.exc_info()[0])+ '\n'+ str(sys.exc_info()[1])+ '\n'+ str(sys.exc_info()[2])
                self.errorMsgSignal.emit(err)
        return deleted
         
    def bkLoadFileIntoManifest(self, locBk, manifestId, basename,  data,  mimeType):    
        loadedIntoManifest= False
        if hC.DEBUG:
            self.errorMsgSignal.emit(debugErrMsg+ 'bkLoadFileIntoManifest')
        else:     
            try:  
                locBk.addfile(manifestId, basename, data, mimeType)
                loadedIntoManifest= True
#                print('caricato in manifest ',  manifestId, ' basename ',  basename, '\n--------', data,  '\nmime ',  mimeType)
            except:
                err= '*bkLoadFileIntoManifest\n'+ str(sys.exc_info()[0])+ '\n'+ str(sys.exc_info()[1])+ '\n'+ str(sys.exc_info()[2])
                self.errorMsgSignal.emit(err)
#                print(err)
        return loadedIntoManifest

    def bkLoadFileIntoSpine(self, locBk, manifestId):
        loadedIntoSpine= False
        if hC.DEBUG:
            self.errorMsgSignal.emit(debugErrMsg+ 'bkLoadFileIntoSpine')        
        else:
            try:
                spineDict=self.bkMakeSpineDict(locBk)
                spineIdLst= list(spineDict.keys())
                spineIdLst.append(manifestId)
                newSpineLst= []
                for spineId in spineIdLst:
                    tup= (spineId, 'yes')
                    newSpineLst.append(tup)
                locBk.setspine(newSpineLst)
                loadedIntoSpine= True
            except:
                err= '*bkLoadFileIntoSpine\n'+ str(sys.exc_info()[0])+ '\n'+ str(sys.exc_info()[1])+ '\n'+ str(sys.exc_info()[2])
                self.errorMsgSignal.emit(err)
#                print(err)
        return loadedIntoSpine
            
    def bkMakeSpineDict(self, locBk):
        '''
            returns spineDict= {manifestId: bk.id_to_href, ...}
            returns empty dict if any error ocurred
        '''          
        spineDict= {}
        if hC.DEBUG:
            self.errorMsgSignal.emit(debugErrMsg+ 'bkMakeSpineDict')
        else:     
            try:
                for manifestId, linear in locBk.getspine():
                    spineDict[manifestId]= locBk.id_to_href(manifestId, ow=None)
                return spineDict
            except:
                err= '*spineDict\n'+ str(sys.exc_info()[0])+ '\n'+ str(sys.exc_info()[1])+ '\n'+ str(sys.exc_info()[2])    
                self.errorMsgSignal.emit(err)
        return spineDict

    def bkSetSpine(self, locBk, newSpineTupleList):
        '''
            set spine to newSpineTupleList (ordered list of tuples)
            newSpineTupleList= [(manifestId, 'yes'), (manifestId, 'yes'), ...] 
        '''
        setSpine= False
        if hC.DEBUG:
            self.errorMsgSignal.emit(debugErrMsg+ 'bkSetSpine')
        else:     
            try:
                locBk.setspine(newSpineTupleList)
                setSpine= True
            except:
                err= '*setSpine\n'+ str(sys.exc_info()[0])+ '\n'+ str(sys.exc_info()[1])+ '\n'+ str(sys.exc_info()[2])    
                self.errorMsgSignal.emit(err)   
        return setSpine

    def bkSearchManifestImage(self, locBk):
        '''
        returns the dictionary imgDataDict= {key: data, ...} where
            keys are manifestId of file images sorted for mime type (gif, jpg, png)
            data is the content of the file.
            imgDataDict= {} if any error
        '''
        imgDataDict= {}        
        if hC.DEBUG:
            self.errorMsgSignal.emit(debugErrMsg+ 'bkSearchManifestImage')
        else: 
            try:
                extNameLst= []
                for manifestId, hrefOPF, mediaType in locBk.manifest_iter():
                    if 'image' in mediaType:
                        extNameLst.append(manifestId[-3:]+ manifestId)
                # sort list for image mime type
                extNameLst.sort()
                # get image file binary content and create dictionary
                for manifestId in extNameLst:
                    manifestId= manifestId[3:]	# remove leading extension from manifestId
                    data= locBk.readfile(manifestId) 
                    imgDataDict[manifestId]= data
            except:
                err= '*setSpine\n'+ str(sys.exc_info()[0])+ '\n'+ str(sys.exc_info()[1])+ '\n'+ str(sys.exc_info()[2])    
                self.errorMsgSignal.emit(err)   
        return imgDataDict
        
    def bkFileContentFromManifestId(self, locBk, manifestId):
        fileContent= ''
        if hC.DEBUG:
            self.errorMsgSignal.emit(debugErrMsg+ 'bkFileContentFromManifestId')
        else:     
            try:
                fileContent= locBk.readfile(manifestId)
            except:
                err= '*bkFileContentFromManifestId\n'+ str(sys.exc_info()[0])+ '\n'+ str(sys.exc_info()[1])+ '\n'+ str(sys.exc_info()[2])    
                self.errorMsgSignal.emit(err)   
        return fileContent        

    def bkLoadFileIntoSigil(self, locBk, manifestId, fileContent, mimeType, loadIntoSpine, askIfFileAlreadyIn):
        retVal= True
        if hC.DEBUG:
            self.errorMsgSignal.emit(debugErrMsg+ 'bkLoadFileIntoSigil')  
            retVal= False
        else:    
            alreadyLoaded= self.bkSearchManifestId(locBk, manifestId)
            if alreadyLoaded and askIfFileAlreadyIn:
                question= QMessageBox()
                loadAnyway= QMessageBox.question(question, "Check for manifestId "+ manifestId,
                        manifestId+ " page already loaded in Sigil.\nDo you wish to reload?",
                        QMessageBox.Yes | QMessageBox.No, QMessageBox.Yes)  
                if loadAnyway== QMessageBox.Yes:  
                    self.bkWriteFile(locBk,  manifestId,  fileContent)
                    return retVal
                else:
                    retVal= False
            if retVal:
                if alreadyLoaded:
                    # already in manifest: load only data
                    retval= self.bkWriteFile(locBk,  manifestId,  fileContent)
                    return retval
                else:
                    retVal= self.bkLoadFileIntoManifest(locBk, manifestId, manifestId,  fileContent,  mimeType)
                if retVal and loadIntoSpine:  
                    retVal= self.bkLoadFileIntoSpine(locBk, manifestId )  
#                    print('-------------------------LETTO IN MEMORIA\n', self.bkFileContentFromManifestId(locBk, manifestId))
        return retVal


    def bkManifestList(self,  locBk):
        '''
            For each entry in Manifest creates a tupla (manifestId, href, mimeType).
            Returns a list of tuplas 
        '''        
        manifestLst= []
        if hC.DEBUG:
            self.errorMsgSignal.emit(debugErrMsg+ 'bkManifestList') 
        else:
            try:
                for manifestId, href, mimeType in locBk.manifest_iter():
                    manifestLst.append((manifestId, href, mimeType)) 
            except:
                err= '*bkManifestList\n'+ str(sys.exc_info()[0])+ '\n'+ str(sys.exc_info()[1])+ '\n'+ str(sys.exc_info()[2])    
                self.errorMsgSignal.emit(err)               
        return manifestLst
        
        
    def bkWriteFile(self, locBk,  manifestId,  fileContent):
        retVal= False
        if hC.DEBUG:
            self.errorMsgSignal.emit(debugErrMsg+ 'bkWriteFile') 
        else:  
            try:
                locBk.writefile(manifestId, fileContent)
                retVal= True
            except:
                err= '*bkWriteFile\n'+ str(sys.exc_info()[0])+ '\n'+ str(sys.exc_info()[1])+ '\n'+ str(sys.exc_info()[2])    
                self.errorMsgSignal.emit(err) 
#                print(err)
        return retVal
#                       
