#----------------------------------------------------------------------------
# hQTableWidgetE.py   
#----------------------------------------------------------------------------
import os
from PyQt5.QtWidgets import (QTableWidget, QTableWidgetItem,  QPushButton,  QComboBox, 
                                QHBoxLayout,  QLabel, QFrame)
from PyQt5.QtCore import Qt
from PyQt5.QtGui import QColor
from PyQt5.QtGui import QIcon,  QKeyEvent
from PyQt5.QtCore import pyqtSignal


import hConstant as hC
import hSigilBkUtil as hBk

TABLE_ADD_ROW= 'r'
TABLE_ADD_COL= 'c'
TABLE_MOVE_UP= 'u'
TABLE_MOVE_DOWN= 'd'
TABLE_MOVE_START= 's'
TABLE_MOVE_END= 'e'
TABLE_EDITABLE= True
TABLE_NOT_EDITABLE= False


class QTableWidgetE(QTableWidget):
    btnChooseImg= pyqtSignal(list)
  
    def __init__(self,  row,  col, bk):
        super().__init__(row, col)
        self.bk= bk

        if hC.DEBUG:
            self.iconPath= 'images/'
        else:
            self.iconPath= os.path.join(self.bk._w.plugin_dir, self.bk._w.plugin_name, 'images/')          

    def tableValueFromDict(self, locTable, locDict, editable):
        '''
            locTable has 2 cols
            Keys are in 1st column. Values are in 2th column.
            type(cell content)= text
        '''         
        dictKeyLst= locDict.keys()   
        for key in dictKeyLst:
            colValueLst= [QTableWidgetItem(key), QTableWidgetItem(locDict[key])]   
            self.tableAdd(TABLE_ADD_ROW, locTable)
            row= locTable.currentRow()            
            for col in range(0, locTable.columnCount()):  
                locTable.setItem(row, col, colValueLst[col] )
                if editable== TABLE_NOT_EDITABLE:
                    colValueLst[col].setFlags(colValueLst[col].flags() ^ Qt.ItemIsEditable)
        locTable.setCurrentCell(0, 0)

    def fromTableToDict(self, locTable):
        '''
            returns table content as dictionary. 
                locTable has 2 cols
                Keys are in 1st column. Values are in 2th column.
                type(cell content)= text
        ''' 
        locDict= {}
        rows= locTable.rowCount()
        for row in range(0, rows):
            locTable.setCurrentCell (row, 0)
            key= locTable.currentItem().text()
            locTable.setCurrentCell (row, 1)
            value= locTable.currentItem().text()
            locDict[key]= value
        return locDict   
        

    def tableSetHeader(self, locTable, headerLst):
        for col, header in list(enumerate(headerLst)):
            item= QTableWidgetItem(header)
            locTable.setHorizontalHeaderItem(col, item)

    def tableAdd(self, rowOrCol, locTable):
        if (rowOrCol== TABLE_ADD_ROW):
            # add row down
            currentRow= locTable.currentRow()
            currentRow+= 1
            locTable.insertRow(currentRow)
            locTable.setCurrentCell(currentRow, 0)
        elif  rowOrCol== TABLE_ADD_COL:
            # add col left
            currentCol= locTable.currentColumn()
            locTable.insertColumn(currentCol+ 1)        

    def tableCellClicked(self, row,  col):
#        print(f"row {row}   col {col}")
        return (row, col)

    def tableMoveRow(self, locTable, oper):
        currRow= locTable.currentRow() 
        rowCount= locTable.rowCount()
        if oper== TABLE_MOVE_UP:
            if currRow != 0:
                destRow= currRow- 1
                self.tableSwapRows(locTable, currRow, destRow)
            else:
                destRow= 0
        if oper== TABLE_MOVE_DOWN:
            if currRow != rowCount- 1:  
                destRow= currRow+ 1
                self.tableSwapRows(locTable, currRow, destRow)
            else:
                destRow= rowCount- 1
        if oper== TABLE_MOVE_START:
            if currRow != 0:
                destRow= 0
                self.tableMoveTo(locTable, currRow, TABLE_MOVE_START)
            else:
                destRow= 0
        if oper== TABLE_MOVE_END:
            if currRow != rowCount- 1:
                destRow= locTable.rowCount()- 1
                self.tableMoveTo(locTable, currRow, TABLE_MOVE_END)
            else:
                destRow= rowCount- 1
        locTable.selectRow(destRow)
    
    def tableSwapRows(self, locTable, originRow,  destRow):
        nCol= locTable.columnCount()
        # save values of origin and destination rows...
        originRowItemLst= []        
        for col in range(0, nCol):
            locTable.setCurrentCell (originRow, col)
            originRowItemLst.append(locTable.currentItem())
            locTable.takeItem (originRow, col)            
        destRowItemLst= []
        for col in range(0, nCol):
            locTable.setCurrentCell (destRow, col)
            destRowItemLst.append(locTable.currentItem())    
            locTable.takeItem (destRow, col)            
        # ...and swap
        for col in range(0, nCol):   
            locTable.setItem(destRow, col, originRowItemLst[col] )
        for col in range(0, nCol):   
            locTable.setItem( originRow,  col,  destRowItemLst[col] )  
        
          
    def tableMoveTo(self, locTable,  originRow,  destination):
        nCol= locTable.columnCount()
        originRowItemLst= []        
        # save origin
        for col in range(0, nCol):
            locTable.setCurrentCell (originRow, col)
            originRowItemLst.append(locTable.currentItem())
            locTable.takeItem (originRow, col) 
        #
        if destination== TABLE_MOVE_END:
            rowCount= locTable.rowCount()
            locTable.insertRow(rowCount)
            destinRow= rowCount
            rowToRemove= originRow
        elif destination== TABLE_MOVE_START:
            locTable.insertRow(0)
            destinRow= 0
            rowToRemove= originRow+ 1
        #
        for col in range(0, nCol):   
            locTable.setItem( destinRow,  col,  originRowItemLst[col] )   
        #
        locTable.removeRow(rowToRemove)
        locTable.setCurrentCell (destinRow, 0) 
 
 
    def manifestTableFromList(self,  locTable, locLst, editable):
        for manifestEntry in locLst: 
            self.tableAdd(TABLE_ADD_ROW, locTable)
            row= locTable.currentRow()             
            colValueLst= []
            for element in manifestEntry:
                colValueLst.append(QTableWidgetItem(element))
            for col in range(0, locTable.columnCount()): 
                locTable.setItem(row, col, colValueLst[col] )
                if editable== TABLE_NOT_EDITABLE:
                    colValueLst[col].setFlags(colValueLst[col].flags() ^ Qt.ItemIsEditable)
        locTable.setCurrentCell(0, 0)


    def setColorToRow(self, locTable, rowIndex, backColor,  foreColor):
        for row in range(locTable.columnCount()):
            locTable.item(rowIndex, row).setBackground(QColor(backColor))
            locTable.item(rowIndex, row).setForeground(QColor(foreColor))
        

    def addXTableFromList(self,  locTable, locLst, isEdit): 
        # position cursor on the last row then add lines (self.tableAdd())
        row= locTable.rowCount()- 1
        locTable.setCurrentCell(row, 0)
        #
        for rowN, rowToAdd in enumerate(locLst): 
            self.tableAdd(TABLE_ADD_ROW, locTable)
            row= locTable.rowCount()- 1          
            colValueLst= []
            for element in rowToAdd:
                colValueLst.append(QTableWidgetItem(element))
            for col in range(0, locTable.columnCount()): 
                locTable.setItem(row, col, colValueLst[col] )
                if colValueLst[col].text()== 'choose':
                    self.addCombo(locTable, row, col)
                editOk= isEdit[rowN]
                if editOk== '0' or col== 0 or colValueLst[col].text()== 'choose':
                    colValueLst[col].setFlags(colValueLst[col].flags() ^ Qt.ItemIsEditable)
        locTable.setCurrentCell(0, 1)  


    def addButton(self, locTable,  row,  col, btnCaption,  imgBaseName):
        btn= QPushButton(btnCaption)
        btn.setIcon(QIcon(self.iconPath+ imgBaseName ))
        btn.clicked.connect(lambda: self.chooseLogo(row,  col)) 
        
        locTable.setCellWidget(row, col, btn )


    def addCombo(self, locTable,  row, col):
        if hC.DEBUG:
            imgDataDict= {'': '', 'LaMalattiaCopertina.jpg':'', 'DettaglioRuotato90.jpg': '', 'GolfoRuotato90.jpg ': ''  } 
        else:
            bkUtil= hBk.BkUtil()            
            imgDataDict= bkUtil.bkSearchManifestImage(self.bk)                 
        if imgDataDict:            
            self.logoRow= row
            self.logoCol= col    
            
            locTable.setRowHeight(row, 40)            
            imgLst= ['']+ list(imgDataDict.keys())
            imgCombo= QComboBox()
            imgCombo.currentTextChanged.connect(self.chooseLogo) 
            imgCombo.addItems(imgLst) 
            imgLbl= QLabel('           ')

            comboFrame= QFrame()            
            comboLayout= QHBoxLayout()          
            comboLayout.addWidget(imgLbl)
            comboLayout.addWidget(imgCombo)              
            comboFrame.setLayout(comboLayout)
    
            locTable.setCellWidget(row, col, comboFrame )

            

##  OK FOR BUTTON
##    def chooseLogo(self, row,  col):
##        self.btnChooseImg.emit([row,  col+1])        # image name in col at right of button

    def chooseLogo(self,  img):
        self.btnChooseImg.emit([self.logoRow,  self.logoCol+1,  img])


    def fromTableToDictRepeatedKey(self, locTable):
        '''
            returns table content as dictionary. 
                locTable has 2 cols
                Keys are in 1st column. Values are in 2th column.
                type(cell content)= text
                If key repeated => change key adding a number
        '''
        changeKey= 1
        locDict= {}
        rows= locTable.rowCount()
        for row in range(0, rows):
            locTable.setCurrentCell (row, 0)
            key= locTable.currentItem().text()
            if key in list(locDict.keys()):
                key= key+ '|'+ str(changeKey)
                changeKey+= 1                
            locTable.setCurrentCell (row, 1)
            value= locTable.currentItem().text()
            locDict[key]= value
        return locDict           
 

    def clearTable(self,  locTable):
        rowNr= locTable.rowCount()
        for row in range (rowNr, -1, -1):
            locTable.removeRow(row)


    def keyPressEvent(self, event: QKeyEvent):
        if event.key() == Qt.Key_Return:  
            col = self.currentColumn()
            row = self.currentRow()
            rowNr= self.rowCount()
            if (row+1) > (rowNr- 1):
                self.setCurrentCell(0, col)
            else:
                self.setCurrentCell(row + 1, col)
