#----------------------------------------------------------------------------
# hHtmlParser.py
# https://docs.python.org/3/library/html.parser.html
#----------------------------------------------------------------------------

from html.parser import HTMLParser

eq= '='
sp= ' '

class MyHTMLParser(HTMLParser):
    def __init__(self):
        super().__init__()
        self.newChunk= ''
        self.endTable= False
 
 
    def handle_starttag(self, tag, attrs):
        self.newChunk= self.newChunk+ '<' + tag
        if  tag != 'span':      #for span tag no attributes
            for name, value in attrs:
                if value== None:
                    value= ''
                self.newChunk= self.newChunk+ sp+ name+ eq+ '"'+ value+ '"'
            if tag== 'table':
                self.newChunk= self.newChunk+ '><tbody'
        self.newChunk= self.newChunk + '>'      
        
        
    def handle_endtag(self, tag):
        self.newChunk= self.newChunk+ '</' 
        if tag== 'table':
            self.newChunk= self.newChunk+ 'tbody></'+ tag
            self.endTable= True
        else:
            self.newChunk= self.newChunk+ tag
        self.newChunk= self.newChunk+ '>\n'       
####        if self.endTable:
####            self.printTag()
        

    def handle_data(self, data):
        self.newChunk= self.newChunk+ data

####    def printTag(self):
####        print(self.newChunk)


