#----------------------------------------------------------------------------
# hFontClass.py
#----------------------------------------------------------------------------
from PyQt5.QtGui import QFontDatabase


class MyFonts():
    def __init__(self):

        self.database = QFontDatabase()
        self.familyLst= []
#        self.pointsLst= []
        
    def getFamilyLst(self):
        for family in self.database.families():
            self.familyLst.append(family)
 
    def getDefaultFontStyle(self, family):
        fontStyleLst= []
        for style in self.database.styles(family):
            fontStyleLst.append(style)
        return fontStyleLst[0]
        
    def getPoints(self, family, defaultStyle):
        self.pointsLst= []
        for points in self.database.smoothSizes(family, defaultStyle):
            self.pointsLst.append(str(points))        
        return self.pointsLst

        
    
    
