#----------------------------------------------------------------------------
# hFileClassE.py
#----------------------------------------------------------------------------
import os
import csv
from PyQt5.QtCore import QObject, QFileInfo
from PyQt5.QtGui import QPixmap
from subprocess import Popen
#import codecs


class File(QObject):
    # inheritance from QObject required to use pyqtSignal in son classes
    def __init__(self, configContainer= None):
        super().__init__()
        #
#        self.configContainer= configContainer
        #
        self.IMAGE_FILE_EXTENSIONS= 'jpggifpngJPGGIFPNG'
        self.TEXT_FILE_EXTENSIONS= 'xhtmlXHTML'
        self.CSS_FILE_EXTENSIONS= 'cssCSS'
        self.CSV_FILE_EXTENSIONS= 'csvCSV'
        self.DOCX_FILE_EXTENSIONS= 'docxDOCX'
        self.EXE_FILE_EXTENSIONS= 'exeEXE'
        self.TXT_FILE_EXTENSIONS= 'txtTXT'
        self.HTM_FILE_EXTENSIONS= 'htmHTM'
        self.PYTHON_FILE_EXTENSION= 'pyPY'

        self.mimeDict= {'xhtml': "application/xhtml+xml",
                        'css': "text/css",
                        'jpg': "image/jpeg", 
                        'gif': "image/gif", 
                        'png': "image/png", 
                        'csv': "text/csv", 
                        'docx': "doc/docx", 
                        'exe': "exe/exe", 
                        'txt': "txt/txt", 
                        'htm': "application/xhtml+xml", 
                        'py': "txt/txt"}        
        
    def setFileProperties(self, fileNameAndPath):
        self.baseNameAndPath= fileNameAndPath
        self.baseName= os.path.basename(self.baseNameAndPath)
        self.dirName= os.path.dirname(self.baseNameAndPath) 
        self.extension= os.path.splitext(self.baseName)[1] 
        self.extension= self.extension.replace('.', '')
        self.onlyName= os.path.splitext(self.baseName)[0]
        #
        info= QFileInfo(self.baseNameAndPath)
        self.fileSize= str(int(info.size()/ 1024))
        #
        self.idSigil= self.baseName
        self.isImage= False
        self.isCsv= False
        self.isDocx= False
        self.isExe= False        
        #
        if self.extension == '':
            self.mime= ''
        else:
            self.mime= self.mimeDict[self.extension]
            if self.extension!= '' and self.extension in self.IMAGE_FILE_EXTENSIONS:
                self.isImage= True
                self.idSigil= 'Img_'+ self.idSigil
                pixmap = QPixmap(self.baseNameAndPath, format = self.extension)
                self.pixmapHeight = str(pixmap.height())
                self.pixmapWidth = str(pixmap.width())
            elif self.extension in self.CSV_FILE_EXTENSIONS:
                self.isCsv= True
            elif self.extension in self.DOCX_FILE_EXTENSIONS:
                self.isDocx= True
            elif self.extension in self.EXE_FILE_EXTENSIONS:
                self.isExe= True
        
        self.nameSigil= self.baseName
    
    def fileExists(self):
        fileExists= False
        if os.path.exists(self.baseNameAndPath):
            fileExists= True
        return fileExists
        
    def delete(self):
        if self.fileExists():
            os.remove(self.baseNameAndPath)

    def show(self, editor):
        """
            opens file in editor notepad or notepad++ according to editor value
        """
        if '++' in editor:
            commandString= 'C:\\Program Files\\Notepad++\\notepad++.exe '+ self.baseNameAndPath
            Popen(commandString)  
        else:
            commandString = "notepad.exe " + self.baseNameAndPath
            Popen(commandString)        # asynchronous            

    def read(self):
        if self.extension in self.IMAGE_FILE_EXTENSIONS: 
            f = open(self.baseNameAndPath, 'rb')
            binarycontent = f.read()  
            f.close()
            return binarycontent
        else:
            fileContent= ''
#            print('prima di open ', self.baseNameAndPath)
            f= open(self.baseNameAndPath,  'r')
            for record in f:
                fileContent+= record
            f.close()
            return fileContent  
 
    def readAll(self):
        f = open(self.baseNameAndPath, 'r')
        fileContent = f.read()
        f.close()        
        return fileContent         
         
    def readByte(self):
        f = open(self.baseNameAndPath, 'rb')
        binarycontent = f.read()  
        f.close()
        return binarycontent
            
    def write(self, fileContent):
        f = open(self.baseNameAndPath, "w")
        f.write(fileContent)
        f.close()

    def writeByte(self, fileContent):
        f = open(self.baseNameAndPath, "wb")
        f.write(fileContent)
        f.close()

            
    def readCsv(self):
        if not self.fileExists():
#            print('NOT EXISTING FILE ',  self.baseNameAndPath)
            return False
        else:    
            if self.isCsv:                                 
                csvContentLst= []
                with open(self.baseNameAndPath, 'r') as csvfile:
                    reader = csv.reader(csvfile,  delimiter=';') 
                    for row in reader:
                        csvContentLst.append(row)
                return csvContentLst
            else:
#                print('NOT A CSV FILE')
                return False
        
    def writeCsv(self, toWriteLst): 
        if self.isCsv:                               
            with open(self.baseNameAndPath, 'w', newline='') as csvfile:
                writer = csv.writer(csvfile, delimiter=';')
                writer.writerows(toWriteLst)
            return True
        else:
#                print('NOT A CSV FILE')
            return False
        
    def openTextFile(self, mode):
        """
            opens text file (.txt, htm, xhtml, etc.) with mode 
        """
        textObjFile= open(self.baseNameAndPath,  mode)
        return textObjFile        
        
