#----------------------------------------------------------------------------
# hCsvUtil.py
#----------------------------------------------------------------------------
import sys
import os
import re
from PyQt5.QtWidgets import QTableWidgetItem
from PyQt5.QtCore import pyqtSignal,  QObject,  Qt
import win32com.client as win32
#import hConstant as hC
import hFileClassE as hFc


def loadCsvFile(fileName,  maxColInCsv, csvValueTable):
    FILE_CSV= hFc.File ()
    FILE_CSV.setFileProperties(fileName)
    csvFileContent= FILE_CSV.read()
    csvFileContentLst= csvFileContent.splitlines()
    row= 0 
    for lineN, record in list(enumerate(csvFileContentLst)):
        record= record.split(';')
        if len(record) != maxColInCsv:
            return -1           # wrong Csv column number
        if lineN== 0: 
            # ---   table headers row
            col= 0  
            for title in record:
                if title != '':
                    item= QTableWidgetItem(title)
                    item.setFlags(item.flags() ^ Qt.ItemIsEditable)
                    csvValueTable.setHorizontalHeaderItem(col, item)
                    col+= 1
        else:
            # ---   data rows
            col= 0
            csvValueTable.setCurrentCell(row, col)
            for value in record:
                item= QTableWidgetItem(value)
                item.setFlags(item.flags() ^ Qt.ItemIsEditable)
                csvValueTable.setItem(row, col, item) 
                col+= 1
            if row <= (len(csvFileContentLst)-3):
                row+= 1
                csvValueTable.insertRow(row)
            else:
                break

class CreateCsvFile (QObject):
    csvLineAdded = pyqtSignal(str)
    maxParagraphsSignal= pyqtSignal(int)    
    progressTabBarSignal= pyqtSignal(int)
    # inheritance from QObject required to use pyqtSignal
    def __init__(self):
        super().__init__()
        
    
    def docx2Csv(self, docxFileNameAndPath, workingDir, docxSplitStyleLineE):
        # constant to interact with WinWord object model
        wdGoToPage= 1
        wdGoToAbsolute= 1
        wdPrintView= 3
        wdStatisticPages= 2
        wdStatisticParagraphs= 4
        wdDoNotSaveChanges= 0
        #
        #   csv file object creation
        csvFileNameAndPath= workingDir+ os.path.splitext(os.path.basename(docxFileNameAndPath))[0]+'.csv'
        docxCsvFile= hFc.File()
        docxCsvFile.setFileProperties(csvFileNameAndPath)        
        try:
            oApp = win32.Dispatch("Word.Application")
        #    oApp.visible= False
            oDoc = oApp.Documents.Add(docxFileNameAndPath)    
            oDoc.ActiveWindow.View.Type= wdPrintView 
            
            maxPages = oDoc.ComputeStatistics(wdStatisticPages)
            maxParagraphs= oDoc.ComputeStatistics(wdStatisticParagraphs)
            self.maxParagraphsSignal.emit(maxParagraphs)
            #
            startP= 1
            endP= startP
            paragraphCounter= 0
            #
            csvLst= []          # list of chapterLst to save in csvFileNameAndPath  
            #
            chapterLst= ['Title', 'startPage',  'endPage', 'pageNr', 'output prefix']
            csvLst.append(chapterLst)
            #log
            msg= 'chapterList '+ str(chapterLst)
            self.csvLineAdded.emit(msg)
            #
            chapterLst= []      # [chapter title, startPage, endPage, nPageInChapter]
            outputPrefix= 1     
            CSV_STYLE_TO_SEARCH= docxSplitStyleLineE
            for startP in range(1, maxPages+1):
                oApp.Selection.GoTo (What=wdGoToPage, Which=wdGoToAbsolute, Count=startP)
                rgePages = oApp.Selection.Range
                oApp.Selection.GoTo (What=wdGoToPage, Which=wdGoToAbsolute, Count=endP)
                rgePages.End = oApp.Selection.Bookmarks("\\Page").Range.End
                #   select range
                rgePages.Select() 

                for  docPara in oApp.Selection.Paragraphs:
                    paragraphCounter+= 1
                    if CSV_STYLE_TO_SEARCH in docPara.Range.Style.NameLocal:
                        if chapterLst!= []:
                            # completa i valori del capitolo precedente con la pagina finale
                            lastP= endP- 1
                            chapterLst.append(lastP)
                            nPages= lastP- chapterLst[1]+ 1
                            chapterLst.append(nPages)
                            chapterLst.append(outputPrefix)
                            outputPrefix+= 1  
                            # log
                            msg= 'chapterList '+ str(chapterLst)
                            self.csvLineAdded.emit(msg)
                            self.progressTabBarSignal.emit(paragraphCounter)
                            csvLst.append(chapterLst) 
                            chapterLst= []
                        chapterTitle= re.sub(r'[\x0c-\r]', '', docPara.Range.Text)
                        chapterLst.append(chapterTitle)     # chapter title
                        chapterLst.append(startP)           # starting page
                                       
                startP+= 1
                endP= startP  
            #
            # last chapter 
            lastP= endP- 1
            chapterLst.append(lastP)
            #
            #   if len(chapterLst)== 1 then no heading found
            if len(chapterLst) != 1:
                nPages= lastP- chapterLst[1]+ 1
                chapterLst.append(nPages)
                chapterLst.append(outputPrefix)    
                csvLst.append(chapterLst) 
                # log
                msg= 'chapterList '+ str(chapterLst)
                self.csvLineAdded.emit(msg)    
                self.progressTabBarSignal.emit(maxParagraphs) 
#                print('h ',  maxParagraphs)
                # write in csvFileNameAndPath  the results of docxFileNameAndPath analysis
                docxCsvFile.writeCsv(csvLst)
                #
                #   close all .docx files 
                for doc in oApp.Documents:
                    doc.Close (wdDoNotSaveChanges)
                # quit from Word.Application    
                oApp.Quit()
            else:
                docxCsvFile.delete()
                return 'No chapter heading found'    
        except:
            docxCsvFile.delete()            
            errMsg= sys.exc_info()[0]+ '\n'+ sys.exc_info()[1]+ '\n'+ sys.exc_info()[2]
            return errMsg
        return ''
