#!/bin/sh

# Block OTA updates
rename_ota_binaries() {
  if [ -f "$1" ] && [ -f "$2" ]; then
    mntroot rw

    for otabin in "$1" "$2"; do
      mv "$otabin" "$otabin~"
    done

    mntroot ro
    fbink -pm -y -5 -F TERMINUS "Operation completed!" "Rebooting in 5s..."
    sleep 5
    reboot
  else
    fbink -pm -y -5 -F TERMINUS "Operation failed!" "Could not find binaries."
  fi
}

# Allow OTA updates
restore_ota_binaries() {
  if [ ! -f "$1" ] && [ ! -f "$2" ]; then
    mntroot rw

    for otabin in "$1" "$2"; do
      mv "$otabin~" "$otabin"
    done

    mntroot ro
    fbink -pm -y -5 -F TERMINUS "Operation completed!" "Rebooting in 5s..."
    sleep 5
    reboot
  else
    fbink -pm -y -5 -F TERMINUS "Operation failed!" "Could not find binaries."
  fi
}

# Block logging
rename_log_binaries() {
  if [ ! -L "$1" ] && [ ! -L "$2" ] && [ ! -L "$3" ] && [ ! -L "$4" ]; then
    mntroot rw

    for logbin in "$1" "$2" "$3" "$4"; do
      # Backup and link to /dev/null
      ln -s -b /dev/null "$logbin"
    done

    mntroot ro
    fbink -pm -y -5 -F TERMINUS "Operation completed!" "Rebooting in 5s..."
    sleep 5
    reboot
  else
    fbink -pm -y -5 -F TERMINUS "Operation failed!" "Could not find binaries."
  fi
}

# Restore logging
restore_log_binaries() {
  if [ -L "$1" ] && [ -L "$2" ] && [ -L "$3" ] && [ -L "$4" ]; then
    mntroot rw

    for logbin in "$1" "$2" "$3" "$4"; do
      mv "$logbin~" "$logbin"
    done

    mntroot ro
    fbink -pm -y -5 -F TERMINUS "Operation completed!" "Rebooting in 5s..."
    sleep 5
    reboot
  else
    fbink -pm -y -5 -F TERMINUS "Operation failed!" "Could not find binaries."
  fi
}

# Main script
case "${1}" in
  "block_ota_updates" )
    rename_ota_binaries /usr/bin/otaupd /usr/bin/otav3
  ;;
  "allow_ota_updates" )
    restore_ota_binaries /usr/bin/otaupd /usr/bin/otav3
  ;;
  "block_logging" )
    rename_log_binaries /usr/sbin/syslog-ng /usr/sbin/loginfo /usr/sbin/tinyrot /usr/bin/showlog
  ;;
  "restore_logging" )
    restore_log_binaries /usr/sbin/syslog-ng /usr/sbin/loginfo /usr/sbin/tinyrot /usr/bin/showlog
  ;;
  * )
    echo "Invalid action (${1})" 2>&1 > /dev/null
  ;;
esac

