/*
	go-kobo-input - Basic touch input handling for Kobo ereaders
    Copyright (C) 2018 Sherman Perry

    This file is part of go-kobo-input.

    go-kobo-input is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    go-kobo-input is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with go-kobo-input.  If not, see <https://www.gnu.org/licenses/>.
*/

package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
//	"unicode"
	"os"
	"syscall"
	"unsafe"
	"github.com/shermp/go-fbink-v2/gofbink"
	"github.com/shermp/go-kobo-input/koboin"
	"github.com/shermp/go-osk/osk"
//	"github.com/shermp/kobo-sim-usb/simusb"
)

var ttyFile *os.File
var eno syscall.Errno
//var key byte
var	upperCase bool
var	ctlState bool
var	altState bool
// sendAnsiSeq sends an ANSI escape string to open tty  
func sendAnsiSeq(ansiSeq string) syscall.Errno {
	seqBytes := []byte(ansiSeq)
	for i := 0; i < len(seqBytes); i++ { 
		_, _, eno = syscall.Syscall(syscall.SYS_IOCTL,ttyFile.Fd(),syscall.TIOCSTI,uintptr(unsafe.Pointer(&seqBytes[i])),)
		if eno != 0 {
			return eno
		} 
	}
	return 0
}

func main() {
	// Get the input event filepath
	touchPath := "/dev/input/event1"
	// Create an input object
	t := koboin.New(touchPath, 1080, 1440)
	if t == nil {
		return
	}
	defer t.Close()

	// Create and init FBInk
	cfg := gofbink.FBInkConfig{}
	rCfg := gofbink.RestrictedConfig{}
	rCfg.Fontmult = 3
	rCfg.Fontname = gofbink.IBM
	fb := gofbink.New(&cfg, &rCfg)
	fb.Open()
	defer fb.Close()
	fb.Init(&cfg)
	var err error
	var tty = "/dev/pts/0"
	ttyFile, err = os.Open(tty)
	if err != nil {
		fmt.Println(err)
		tty = "/dev/pts/1"
		ttyFile, err = os.Open(tty)
		if err != nil {
			fmt.Println(err)
		}
	}
	defer ttyFile.Close()

	// Use kobo-sim-usb to enter USBMS mode where we can use the
	// touchscreen without unintended presses in Nickel
//	u, err := simusb.New(fb)
//	if err != nil {
//		fmt.Println(err)
//	}
//	err = u.Start(true, true)
//	if err != nil {
//		fmt.Println(err)
//		return
//	}
//	defer u.End(true)
	fb.Println("Welcome to the test!")
	fb.Println("Have Fun!")
	var k osk.Key
	var prevType int

	// Load a keymap file for the OSK
	keymap1JSON, _ := ioutil.ReadFile("./keymap1-en_us.json")
	km1 := osk.KeyMap{}
	json.Unmarshal(keymap1JSON, &km1)
	// Create an OSK
	vk1, _ := osk.New(&km1, 1080, 1440)
	// Generate an image of the OSK
	vk1PNG := "./osk1-en_us.png"
	vk1Font := "./Roboto-Medium.ttf"
	vk1.CreateIMG(vk1PNG, vk1Font)

	// Load a keymap file for the OSK
	keymap2JSON, _ := ioutil.ReadFile("./keymap2-en_us.json")
	km2 := osk.KeyMap{}
	json.Unmarshal(keymap2JSON, &km2)
	// Create an OSK
	vk2, _ := osk.New(&km2, 1080, 1440)
	// Generate an image of the OSK
	vk2PNG := "./osk2-en_us.png"
	vk2Font := "./Roboto-Medium.ttf"
	vk2.CreateIMG(vk2PNG, vk2Font)

	// Print the image to the screen. Its position on screen should match that stored
	// in the keyboard object
	fb.PrintImage(vk1PNG, int16(vk1.StartCoords.X), int16(vk1.StartCoords.Y), &cfg)
//	runeStr := []rune{}
	upperCase = false
	ctlState = false
	altState = false
//	cfg.Row = 16
	// Read the input from the touch screen
//L:
	for {
		x, y, err := t.GetInput()
		if err != nil {
			continue
		}
		if upperCase {
			k, err = vk2.GetPressedKey(x, y)
		} else {
			k, err = vk1.GetPressedKey(x, y)
		}
		if err != nil {
			continue
		}
		if !k.IsKey {
			continue
		}
		switch k.KeyType {
		case osk.KTstandardChar:
			key := k.KeyCode
			tabSeq := []byte(string(key))
			if (ctlState) {
				byteSeq := []byte(tabSeq)
				if 	(byteSeq[0] > 64) && (byteSeq[0] < 91) {
					byteSeq[0] -= 64
					seqErr := sendAnsiSeq(string(byteSeq[0])) 
					if seqErr != 0 {
						fmt.Println(seqErr)
					}
				} else if (byteSeq[0] > 96) && (byteSeq[0] < 123) {
					byteSeq[0] -= 96
					seqErr := sendAnsiSeq(string(byteSeq[0])) 
					if seqErr != 0 {
						fmt.Println(seqErr)
					}
				}			
			} else {
				seqErr := sendAnsiSeq(string(tabSeq)) 
				if seqErr != 0 {
					fmt.Println(seqErr)
				}
			}
		case osk.KTcarriageReturn:
			tabSeq := []byte{13}
			seqErr := sendAnsiSeq(string(tabSeq)) 
			if seqErr != 0 {
				fmt.Println(seqErr)
			}
		case osk.KTbackspace:
			tabSeq := []byte{8}
			seqErr := sendAnsiSeq(string(tabSeq)) 
			if seqErr != 0 {
				fmt.Println(seqErr)
			}
		case osk.KTdelete:
			tabSeq := []byte{127}
			seqErr := sendAnsiSeq(string(tabSeq)) 
			if seqErr != 0 {
				fmt.Println(seqErr)
			}
		case osk.KTcapsLock:
			if prevType != osk.KTcapsLock { 
				upperCase = !upperCase
				if upperCase {
					fb.PrintImage(vk2PNG, int16(vk2.StartCoords.X), int16(vk2.StartCoords.Y), &cfg)
				} else {
					fb.PrintImage(vk1PNG, int16(vk1.StartCoords.X), int16(vk1.StartCoords.Y), &cfg)
				}
			}
		case osk.KTcontrol:
			ctlState = !ctlState
		case osk.KTalt:
			altState = !altState
		case osk.KTesc:
			tabSeq := []byte{27}
			seqErr := sendAnsiSeq(string(tabSeq)) 
			if seqErr != 0 {
				fmt.Println(seqErr)
			}
		case osk.KTtab:
			tabSeq := []byte{9}
			seqErr := sendAnsiSeq(string(tabSeq)) 
			if seqErr != 0 {
				fmt.Println(seqErr)
			}
		case osk.KTup:
			tabSeq := []byte{27,91,65}
			seqErr := sendAnsiSeq(string(tabSeq)) 
			if seqErr != 0 {
				fmt.Println(seqErr)
			}
		case osk.KTdown:
			tabSeq := []byte{27,91,66}
			seqErr := sendAnsiSeq(string(tabSeq)) 
			if seqErr != 0 {
				fmt.Println(seqErr)
			}
		case osk.KTleft:
			tabSeq := []byte{27,91,68}
			seqErr := sendAnsiSeq(string(tabSeq)) 
			if seqErr != 0 {
				fmt.Println(seqErr)
			}
		case osk.KTright:
			tabSeq := []byte{27,91,67}
			seqErr := sendAnsiSeq(string(tabSeq)) 
			if seqErr != 0 {
				fmt.Println(seqErr)
			}
		case osk.KTpgUp:
			tabSeq := []byte{27,91,53,126}
			seqErr := sendAnsiSeq(string(tabSeq)) 
			if seqErr != 0 {
				fmt.Println(seqErr)
			}
		case osk.KTpgDn:
			tabSeq := []byte{27,91,54,126}
			seqErr := sendAnsiSeq(string(tabSeq)) 
			if seqErr != 0 {
				fmt.Println(seqErr)
			}
//			break L
		default:
			continue
		}
		prevType = k.KeyType
	}
}
