#!/bin/sh
# Actually /bin/ash, but don't tell anyone.

# BBB (Big Brother Blocker) for K3-3.3.1 ... Kpw-5.3.1 created on: Sat Feb  9, 2013
# Only tested on K3 and Kpw, but should be better than nothing on the other models.
# Ref: http://www.mobileread.com/forums/showthread.php?t=205224

# Remove the BBB entries one at a time.
IPT=`which iptables`
WHEN=`date -u -Iseconds | sed s/:/./g`
LOG='/mnt/us/documents/del-bbb-'$WHEN'.txt'

echo '*** Delete BBB error log. An empty file here is good! ***' >$LOG 2>&1
echo '*** del-bbb script called at: '$WHEN >>$LOG 2>&1

$IPT -t filter -D usb-out -d 23.0.0.0/12       -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 23.20.0.0/14      -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 50.16.0.0/14      -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 54.240.128.0/18   -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 54.240.0.0/12     -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 64.208.0.0/16     -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 64.209.0.0/17     -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 72.21.192.0/19    -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 107.20.0.0/14     -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 176.32.96.0/21    -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 178.236.0.0/21    -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 184.72.0.0/15     -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 204.246.160.0/19  -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 205.251.192.0/18  -j DROP >>$LOG 2>&1
$IPT -t filter -D usb-out -d 207.171.160.0/19  -j DROP >>$LOG 2>&1

$IPT -t filter -D wlan-out -d 23.0.0.0/12      -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 23.20.0.0/14     -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 50.16.0.0/14     -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 54.240.128.0/18  -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 54.240.0.0/12    -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 64.208.0.0/16    -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 64.209.0.0/17    -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 72.21.192.0/19   -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 107.20.0.0/14    -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 176.32.96.0/21   -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 178.236.0.0/21   -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 184.72.0.0/15    -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 204.246.160.0/19 -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 205.251.192.0/18 -j DROP >>$LOG 2>&1
$IPT -t filter -D wlan-out -d 207.171.160.0/19 -j DROP >>$LOG 2>&1

$IPT -t filter -D ppp-out -d 23.0.0.0/12       -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 23.20.0.0/14      -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 50.16.0.0/14      -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 54.240.128.0/18   -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 54.240.0.0/12     -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 64.208.0.0/16     -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 64.209.0.0/17     -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 72.21.192.0/19    -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 107.20.0.0/14     -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 176.32.96.0/21    -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 178.236.0.0/21    -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 184.72.0.0/15     -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 204.246.160.0/19  -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 205.251.192.0/18  -j DROP >>$LOG 2>&1
$IPT -t filter -D ppp-out -d 207.171.160.0/19  -j DROP >>$LOG 2>&1

# Required by non-touch devices to force update of documents list.
dbus-send --system /default com.lab126.powerd.resuming int32:1 >>$LOG 2>&1

exit 0
