#!/bin/sh
# Setting system and hardware clock to UTC from a network server.
# Requires the ntpdate and hwclock programs provided by Amazon firmware.

# Configuration by an external config file, per:
# Domain name or IPv4 address of server
# Ref: http://tf.nist.gov/tf-cgi/servers.cgi
# NTPD_SERVER='time.nist.gov'

# Output verbosity, 'true' for book-report output on success.
# Any error encountered always outputs a book-report on failure.
# NTPD_REPORT=''
# NTPD_REPORT='true'

# Define NTPD_SERVER and NTPD_REPORT by the user's choices:
source /mnt/us/extensions/helper2/ntpdate.conf

# Writes to ram are much faster than writes to flash.  ;)
LOG=/var/tmp/ntpdate.log
: >$LOG

# Report writer flag ='true' is only value that makes a report.
RPT=''

# Capture any error message and check the source return code.
# NOTE: firmware-5.3.3 Ash will not re-define variables when called here:
if MSG=source /mnt/us/extensions/helper2/ntpdate.conf 2>&1
then
  if MSG=$(ntpdate $NTPD_SERVER 2>&1)
  then
    echo 'System time and date reset using: '$NTPD_SERVER >>$LOG
    echo >>$LOG
    echo 'ntpdate message was: ' >>$LOG
    echo $MSG >>$LOG
    if MSG=$(hwclock -w)
    then
      MSG=$(hwclock -r)
      echo >>$LOG
      echo 'hardware clock reset to system time as:' >>$LOG
      echo $MSG >>$LOG
      if [ x$NTPD_REPORT == 'xtrue' ]
      then
        RPT='true'
      fi
    else
      echo >>$LOG
      echo 'Hardware clock update failed, with message:' >>$LOG
      echo $MSG >>$LOG
      RPT='true'
    fi
  else
    RTN=$?
    echo 'Configured time server: ' $NTPD_SERVER >>$LOG
    echo 'Error Code: '$RTN >>$LOG
    echo 'Message from ntpdate command was:' >>$LOG
    echo $MSG >>$LOG
    echo >>$LOG
    echo 'System time and date not changed.' >>$LOG
    RPT='true'
  fi
else
  RTN=$?
  echo 'Error Code: '$RTN >>$LOG
  echo 'Message was: '$MSG >>$LOG
  echo >>$LOG
  echo 'Configuration file: */extensions/helper2/ntpdated.conf was not used!' >>$LOG
  echo 'System time and date not changed.' >>$LOG
  RPT='true'
fi

if [ x$RPT == 'xtrue' ]
then
  mv $LOG /mnt/us/documents/ntpdate.txt
  dbus-send --system /default com.lab126.powerd.resuming int32:1
else
  rm $LOG
fi

exit 0
