#!/bin/sh
# Load the factory default firewall.

# Writes to ram are much faster than writes to flash.  ;)
LOG=/var/tmp/bbb-last.log
: >$LOG

WHEN=`date -u -Iseconds`
echo 'Restore factory default firewall run at: '$WHEN >>$LOG
echo >>$LOG

SRC='/etc/sysconfig/iptables'

if [ -e $SRC ] && [ -f $SRC ]
then
  if iptables-restore -v < $SRC >>$LOG 2>&1
  then
    echo >>$LOG
    echo 'Factory default firewall restored.' >>$LOG
  else
    echo >>$LOG
    echo 'Failed to restore default factory firewall!' >>$LOG
  fi
else
    echo 'Rule-set file: '$SRC' does not exist.' >>$LOG
fi

mv $LOG /mnt/us/documents/BBB-LastAction.txt
dbus-send --system /default com.lab126.powerd.resuming int32:1

exit 0

