#!/bin/sh
# Load the base BBB (and kWall) firewall structure.

# Writes to ram are much faster than writes to flash.  ;)
LOG=/var/tmp/bbb-last.log
: >$LOG

WHEN=`date -u -Iseconds`
echo 'Load base BBB firewall run at: '$WHEN >>$LOG
echo >>$LOG

SRC='/mnt/us/extensions/bbb/frags/fw-base.txt'

if [ -e $SRC ] && [ -f $SRC ]
then
  if iptables-restore -v < $SRC >>$LOG 2>&1
  then
    echo >>$LOG
    echo 'Basic BBB firewall installed.' >>$LOG
  else
    echo >>$LOG
    echo 'Failed to install basic BBB firewall!' >>$LOG
  fi
else
    echo 'Rule-set file: '$SRC' does not exist.' >>$LOG
fi

mv $LOG /mnt/us/documents/BBB-LastAction.txt
dbus-send --system /default com.lab126.powerd.resuming int32:1

exit 0

