#!/bin/sh
# Transfer kernel ring buffer to a document and clear.

WHEN=`date -u -Iminutes | sed s/:/./g`

# Writes to ram are much faster than writes to flash.  ;)
RPT='dmesg-'$WHEN
LOG='/var/tmp/'$RPT'.log'
: >$LOG

# The default is to clear the ring buffer.
dmesg -c >>$LOG 2>&1

mv $LOG '/mnt/us/documents/'$RPT'.txt'
dbus-send --system /default com.lab126.powerd.resuming int32:1

exit 0

